/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Validatable;
import eu.chargetime.ocpp.model.core.Location;
import eu.chargetime.ocpp.model.core.ValueFormat;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlType(propOrder={"value", "context", "format", "measurand", "phase", "location", "unit"})
public class SampledValue
implements Validatable {
    private static final Logger logger = LoggerFactory.getLogger(SampledValue.class);
    private String value;
    private String context;
    private ValueFormat format;
    private String measurand;
    private String phase;
    private Location location;
    private String unit;

    @Deprecated
    public SampledValue() {
    }

    public SampledValue(String value) {
        try {
            this.setValue(value);
        }
        catch (PropertyConstraintException ex) {
            logger.error("constructor of SampledValue failed", (Throwable)ex);
        }
    }

    public boolean validate() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    @XmlElement
    public void setValue(String value) {
        this.value = value;
    }

    public String getContext() {
        return this.context == null ? "Sample.Periodic" : this.context;
    }

    @XmlElement
    public void setContext(String context) {
        if (context != null && !this.isValidContext(context)) {
            throw new PropertyConstraintException((Object)context, "context is not properly defined");
        }
        this.context = context;
    }

    private boolean isValidContext(String context) {
        String[] readingContext = new String[]{"Interruption.Begin", "Interruption.End", "Other", "Sample.Clock", "Sample.Periodic", "Transaction.Begin", "Transaction.End", "Trigger"};
        return ModelUtil.isAmong((String)context, (String[])readingContext);
    }

    public ValueFormat getFormat() {
        return this.format == null ? ValueFormat.Raw : this.format;
    }

    @XmlElement
    public void setFormat(ValueFormat format) {
        this.format = format;
    }

    @Deprecated
    public ValueFormat objFormat() {
        return this.format == null ? ValueFormat.Raw : this.format;
    }

    public String getMeasurand() {
        return this.measurand == null ? "Energy.Active.Import.Register" : this.measurand;
    }

    @XmlElement
    public void setMeasurand(String measurand) {
        if (measurand != null && !this.isValidMeasurand(measurand)) {
            throw new PropertyConstraintException((Object)measurand, "measurand value is not properly defined");
        }
        this.measurand = measurand;
    }

    private boolean isValidMeasurand(String measurand) {
        String[] measurandValues = new String[]{"Current.Export", "Current.Import", "Current.Offered", "Energy.Active.Export.Register", "Energy.Active.Import.Register", "Energy.Reactive.Export.Register", "Energy.Reactive.Import.Register", "Energy.Active.Export.Interval", "Energy.Active.Import.Interval", "Energy.Reactive.Export.Interval", "Energy.Reactive.Import.Interval", "Frequency", "Power.Active.Export", "Power.Active.Import", "Power.Factor", "Power.Offered", "Power.Reactive.Export", "Power.Reactive.Import", "RPM", "SoC", "Temperature", "Voltage"};
        return ModelUtil.isAmong((String)measurand, (String[])measurandValues);
    }

    public String getPhase() {
        return this.phase;
    }

    @XmlElement
    public void setPhase(String phase) {
        if (phase != null && !this.isValidPhase(phase)) {
            throw new PropertyConstraintException((Object)phase, "phase is not properly defined");
        }
        this.phase = phase;
    }

    private boolean isValidPhase(String phase) {
        return ModelUtil.isAmong((String)phase, (String[])new String[]{"L1", "L2", "L3", "N", "L1-N", "L2-N", "L3-N", "L1-L2", "L2-L3", "L3-L1"});
    }

    public Location getLocation() {
        return this.location == null ? Location.Outlet : this.location;
    }

    @XmlElement
    public void setLocation(Location location) {
        this.location = location;
    }

    @Deprecated
    public Location objLocation() {
        return this.location == null ? Location.Outlet : this.location;
    }

    public String getUnit() {
        return this.unit == null && this.getMeasurand().startsWith("Energy") ? "Wh" : this.unit;
    }

    @XmlElement
    public void setUnit(String unit) {
        if (unit != null && !this.isValidUnit(unit)) {
            throw new PropertyConstraintException((Object)unit, "unit is not properly defined");
        }
        this.unit = unit;
    }

    private boolean isValidUnit(String unit) {
        String[] unitOfMeasure = new String[]{"Wh", "kWh", "varh", "kvarh", "W", "kW", "VA", "kVA", "var", "kvar", "A", "V", "Celsius", "Fahrenheit", "K", "Percent"};
        return ModelUtil.isAmong((String)unit, (String[])unitOfMeasure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampledValue that = (SampledValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.context, that.context) && this.format == that.format && Objects.equals(this.measurand, that.measurand) && Objects.equals(this.phase, that.phase) && this.location == that.location && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.context, this.format, this.measurand, this.phase, this.location, this.unit});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("context", (Object)this.context).add("format", (Object)this.format).add("measurand", (Object)this.measurand).add("phase", (Object)this.phase).add("location", (Object)this.location).add("unit", (Object)this.unit).add("isValid", this.validate()).toString();
    }
}

