/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"connectorId", "idTag", "timestamp", "meterStart", "reservationId"})
public class StartTransactionRequest
implements Request {
    private static final int IDTAG_MAX_LENGTH = 20;
    private static final String IDTAG_ERROR_MESSAGE = "Exceeded limit of 20 chars";
    private Integer connectorId;
    private String idTag;
    private Integer meterStart;
    private Integer reservationId;
    private ZonedDateTime timestamp;

    @Deprecated
    public StartTransactionRequest() {
    }

    public StartTransactionRequest(Integer connectorId, String idTag, Integer meterStart, ZonedDateTime timestamp) {
        this.setConnectorId(connectorId);
        this.setIdTag(idTag);
        this.setMeterStart(meterStart);
        this.setTimestamp(timestamp);
    }

    public boolean validate() {
        boolean valid = this.connectorId != null && this.connectorId > 0;
        valid &= ModelUtil.validate((String)this.idTag, (int)20);
        valid &= this.meterStart != null;
        return valid &= this.timestamp != null;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId == null || connectorId <= 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be > 0");
        }
        this.connectorId = connectorId;
    }

    public String getIdTag() {
        return this.idTag;
    }

    @XmlElement
    public void setIdTag(String idTag) {
        if (!ModelUtil.validate((String)idTag, (int)20)) {
            throw new PropertyConstraintException((Object)idTag.length(), IDTAG_ERROR_MESSAGE);
        }
        this.idTag = idTag;
    }

    public Integer getMeterStart() {
        return this.meterStart;
    }

    @XmlElement
    public void setMeterStart(Integer meterStart) {
        this.meterStart = meterStart;
    }

    public Integer getReservationId() {
        return this.reservationId;
    }

    @XmlElement
    public void setReservationId(Integer reservationId) {
        this.reservationId = reservationId;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @XmlElement
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public ZonedDateTime objTimestamp() {
        return this.timestamp;
    }

    public boolean transactionRelated() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartTransactionRequest that = (StartTransactionRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.idTag, that.idTag) && Objects.equals(this.meterStart, that.meterStart) && Objects.equals(this.reservationId, that.reservationId) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.idTag, this.meterStart, this.reservationId, this.timestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("idTag", (Object)this.idTag).add("meterStart", (Object)this.meterStart).add("reservationId", (Object)this.reservationId).add("timestamp", this.timestamp).add("isValid", this.validate()).toString();
    }
}

