/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.ChargePointErrorCode;
import eu.chargetime.ocpp.model.core.ChargePointStatus;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"connectorId", "status", "errorCode", "info", "timestamp", "vendorId", "vendorErrorCode"})
public class StatusNotificationRequest
implements Request {
    private static final String ERROR_MESSAGE = "Exceeds limit of %s chars";
    private Integer connectorId;
    private ChargePointErrorCode errorCode;
    private String info;
    private ChargePointStatus status;
    private ZonedDateTime timestamp;
    private String vendorId;
    private String vendorErrorCode;

    @Deprecated
    public StatusNotificationRequest() {
    }

    public StatusNotificationRequest(Integer connectorId, ChargePointErrorCode errorCode, ChargePointStatus status) {
        this.setConnectorId(connectorId);
        this.setErrorCode(errorCode);
        this.setStatus(status);
    }

    private static String createErrorMessage(int maxLength) {
        return String.format(ERROR_MESSAGE, maxLength);
    }

    public boolean validate() {
        boolean valid = this.isValidConnectorId(this.connectorId);
        valid &= this.errorCode != null;
        return valid &= this.status != null;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (!this.isValidConnectorId(connectorId)) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId >= 0");
        }
        this.connectorId = connectorId;
    }

    private boolean isValidConnectorId(Integer connectorId) {
        return connectorId != null && connectorId >= 0;
    }

    public ChargePointErrorCode getErrorCode() {
        return this.errorCode;
    }

    @XmlElement
    public void setErrorCode(ChargePointErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Deprecated
    public ChargePointErrorCode objErrorCode() {
        return this.errorCode;
    }

    public String getInfo() {
        return this.info;
    }

    @XmlElement
    public void setInfo(String info) {
        if (!ModelUtil.validate((String)info, (int)50)) {
            throw new PropertyConstraintException((Object)info.length(), StatusNotificationRequest.createErrorMessage(50));
        }
        this.info = info;
    }

    public ChargePointStatus getStatus() {
        return this.status;
    }

    @XmlElement
    public void setStatus(ChargePointStatus status) {
        this.status = status;
    }

    @Deprecated
    public ChargePointStatus objStatus() {
        return this.status;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @XmlElement
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public ZonedDateTime objTimestamp() {
        return this.timestamp;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    @XmlElement
    public void setVendorId(String vendorId) {
        if (!ModelUtil.validate((String)vendorId, (int)255)) {
            throw new PropertyConstraintException((Object)vendorId.length(), StatusNotificationRequest.createErrorMessage(255));
        }
        this.vendorId = vendorId;
    }

    public String getVendorErrorCode() {
        return this.vendorErrorCode;
    }

    @XmlElement
    public void setVendorErrorCode(String vendorErrorCode) {
        if (!ModelUtil.validate((String)vendorErrorCode, (int)50)) {
            throw new PropertyConstraintException((Object)vendorErrorCode.length(), StatusNotificationRequest.createErrorMessage(50));
        }
        this.vendorErrorCode = vendorErrorCode;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusNotificationRequest that = (StatusNotificationRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && this.errorCode == that.errorCode && Objects.equals(this.info, that.info) && this.status == that.status && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.vendorId, that.vendorId) && Objects.equals(this.vendorErrorCode, that.vendorErrorCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectorId, this.errorCode, this.info, this.status, this.timestamp, this.vendorId, this.vendorErrorCode});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("errorCode", (Object)this.errorCode).add("info", (Object)this.info).add("status", (Object)this.status).add("timestamp", this.timestamp).add("vendorId", (Object)this.vendorId).add("vendorErrorCode", (Object)this.vendorErrorCode).add("isValid", this.validate()).toString();
    }
}

