/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.MeterValue;
import eu.chargetime.ocpp.model.core.Reason;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"transactionId", "idTag", "timestamp", "meterStop", "reason", "transactionData"})
public class StopTransactionRequest
implements Request {
    private String idTag;
    private Integer meterStop;
    private ZonedDateTime timestamp;
    private Integer transactionId;
    private Reason reason;
    private MeterValue[] transactionData;

    @Deprecated
    public StopTransactionRequest() {
    }

    public StopTransactionRequest(Integer meterStop, ZonedDateTime timestamp, Integer transactionId) {
        this.setMeterStop(meterStop);
        this.setTimestamp(timestamp);
        this.setTransactionId(transactionId);
    }

    public boolean validate() {
        boolean valid = this.meterStop != null;
        valid &= this.timestamp != null;
        valid &= this.transactionId != null;
        if (this.transactionData != null) {
            for (MeterValue meterValue : this.transactionData) {
                valid &= meterValue.validate();
            }
        }
        return valid;
    }

    public String getIdTag() {
        return this.idTag;
    }

    @XmlElement
    public void setIdTag(String idTag) {
        if (!ModelUtil.validate((String)idTag, (int)20)) {
            throw new PropertyConstraintException((Object)idTag.length(), "Exceeded limit of 20 chars");
        }
        this.idTag = idTag;
    }

    public Integer getMeterStop() {
        return this.meterStop;
    }

    @XmlElement
    public void setMeterStop(Integer meterStop) {
        this.meterStop = meterStop;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @XmlElement
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public ZonedDateTime objTimestamp() {
        return this.timestamp;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    @XmlElement
    public void setTransactionId(Integer transactionId) {
        this.transactionId = transactionId;
    }

    public Reason getReason() {
        return this.reason;
    }

    @XmlElement
    public void setReason(Reason reason) {
        this.reason = reason;
    }

    @Deprecated
    public Reason objReason() {
        return this.reason;
    }

    public MeterValue[] getTransactionData() {
        return this.transactionData;
    }

    @XmlElement
    public void setTransactionData(MeterValue[] transactionData) {
        this.transactionData = transactionData;
    }

    public boolean transactionRelated() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopTransactionRequest that = (StopTransactionRequest)o;
        return Objects.equals(this.idTag, that.idTag) && Objects.equals(this.meterStop, that.meterStop) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.transactionId, that.transactionId) && this.reason == that.reason && Arrays.equals(this.transactionData, that.transactionData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.idTag, this.meterStop, this.timestamp, this.transactionId, this.reason, this.transactionData});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("idTag", (Object)this.idTag).add("meterStop", (Object)this.meterStop).add("timestamp", this.timestamp).add("transactionId", (Object)this.transactionId).add("reason", (Object)this.reason).add("transactionData", (Object[])this.transactionData).add("isValid", this.validate()).toString();
    }
}

