/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.firmware;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"location", "retries", "retrieveDate", "retryInterval"})
public class UpdateFirmwareRequest
implements Request {
    private String location;
    private Integer retries;
    private ZonedDateTime retrieveDate;
    private Integer retryInterval;

    @Deprecated
    public UpdateFirmwareRequest() {
    }

    public UpdateFirmwareRequest(String location, ZonedDateTime retrieveDate) {
        this.setLocation(location);
        this.setRetrieveDate(retrieveDate);
    }

    public boolean validate() {
        return this.location != null && this.retrieveDate != null;
    }

    public String getLocation() {
        return this.location;
    }

    @XmlElement
    public void setLocation(String location) {
        this.location = location;
    }

    public Integer getRetries() {
        return this.retries;
    }

    @XmlElement
    public void setRetries(int retries) {
        if (retries <= 0) {
            throw new PropertyConstraintException((Object)retries, "retries must be > 0");
        }
        this.retries = retries;
    }

    public ZonedDateTime getRetrieveDate() {
        return this.retrieveDate;
    }

    @XmlElement
    public void setRetrieveDate(ZonedDateTime retrieveDate) {
        this.retrieveDate = retrieveDate;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    @XmlElement
    public void setRetryInterval(int retryInterval) {
        if (retryInterval <= 0) {
            throw new PropertyConstraintException((Object)retryInterval, "retryInterval must be > 0");
        }
        this.retryInterval = retryInterval;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateFirmwareRequest that = (UpdateFirmwareRequest)o;
        return this.retryInterval.equals(that.retryInterval) && Objects.equals(this.location, that.location) && Objects.equals(this.retries, that.retries) && Objects.equals(this.retrieveDate, that.retrieveDate);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.retries, this.retrieveDate, this.retryInterval);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).add("retries", (Object)this.retries).add("retrieveDate", this.retrieveDate).add("retryInterval", (Object)this.retryInterval).add("isValid", this.validate()).toString();
    }
}

