/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.localauthlist;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.localauthlist.AuthorizationData;
import eu.chargetime.ocpp.model.localauthlist.UpdateType;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Arrays;
import java.util.Objects;

public class SendLocalListRequest
implements Request {
    private Integer listVersion = 0;
    private AuthorizationData[] localAuthorizationList = null;
    private UpdateType updateType = null;

    @Deprecated
    public SendLocalListRequest() {
    }

    public SendLocalListRequest(Integer listVersion, UpdateType updateType) {
        this.listVersion = listVersion;
        this.updateType = updateType;
    }

    public Integer getListVersion() {
        return this.listVersion;
    }

    public void setListVersion(Integer listVersion) {
        if (listVersion < 1) {
            throw new PropertyConstraintException((Object)listVersion, "listVersion must be > 0");
        }
        this.listVersion = listVersion;
    }

    public AuthorizationData[] getLocalAuthorizationList() {
        return this.localAuthorizationList;
    }

    public void setLocalAuthorizationList(AuthorizationData[] localAuthorizationList) {
        this.localAuthorizationList = localAuthorizationList;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.listVersion != null && this.listVersion >= 1 && this.updateType != null;
        if (this.localAuthorizationList != null) {
            for (AuthorizationData data : this.localAuthorizationList) {
                valid &= data.validate();
                if (this.updateType != UpdateType.Full) continue;
                valid &= data.getIdTagInfo() != null;
            }
        }
        return valid;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendLocalListRequest that = (SendLocalListRequest)o;
        return Objects.equals(this.listVersion, that.listVersion) && Arrays.equals(this.localAuthorizationList, that.localAuthorizationList) && this.updateType == that.updateType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listVersion, this.localAuthorizationList, this.updateType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listVersion", (Object)this.listVersion).add("localAuthorizationList", (Object[])this.localAuthorizationList).add("updateType", (Object)this.updateType).add("isValid", this.validate()).toString();
    }
}

