/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.remotetrigger;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.remotetrigger.TriggerMessageRequestType;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"requestedMessage", "connectorId"})
public class TriggerMessageRequest
implements Request {
    private Integer connectorId;
    private TriggerMessageRequestType requestedMessage;

    @Deprecated
    public TriggerMessageRequest() {
    }

    public TriggerMessageRequest(TriggerMessageRequestType triggerMessageRequestType) {
        this.requestedMessage = triggerMessageRequestType;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId != null && connectorId <= 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be > 0");
        }
        this.connectorId = connectorId;
    }

    public TriggerMessageRequestType getRequestedMessage() {
        return this.requestedMessage;
    }

    @XmlElement
    public void setRequestedMessage(TriggerMessageRequestType requestedMessage) {
        this.requestedMessage = requestedMessage;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean validate() {
        boolean valid = this.requestedMessage != null;
        return valid &= this.connectorId == null || this.connectorId > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerMessageRequest that = (TriggerMessageRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && this.requestedMessage == that.requestedMessage;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectorId, this.requestedMessage});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("requestedMessage", (Object)this.requestedMessage).add("isValid", this.validate()).toString();
    }
}

