/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.reservation;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"connectorId", "expiryDate", "idTag", "parentIdTag", "reservationId"})
public class ReserveNowRequest
implements Request {
    private static final int ID_TAG_MAX_LENGTH = 20;
    private static final String ERROR_MESSAGE = "Exceeded limit of 20 chars";
    private Integer connectorId;
    private ZonedDateTime expiryDate;
    private String idTag;
    private String parentIdTag;
    private Integer reservationId;

    @Deprecated
    public ReserveNowRequest() {
    }

    public ReserveNowRequest(Integer connectorId, ZonedDateTime expiryDate, String idTag, Integer reservationId) {
        this.setConnectorId(connectorId);
        this.setExpiryDate(expiryDate);
        this.setIdTag(idTag);
        this.setReservationId(reservationId);
    }

    public boolean validate() {
        boolean valid = this.connectorId != null && this.connectorId >= 0;
        valid &= this.expiryDate != null;
        valid &= ModelUtil.validate((String)this.idTag, (int)20);
        return valid &= this.reservationId != null;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId < 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be >= 0");
        }
        this.connectorId = connectorId;
    }

    public ZonedDateTime getExpiryDate() {
        return this.expiryDate;
    }

    @XmlElement
    public void setExpiryDate(ZonedDateTime expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getIdTag() {
        return this.idTag;
    }

    @XmlElement
    public void setIdTag(String idTag) {
        if (!ModelUtil.validate((String)idTag, (int)20)) {
            throw new PropertyConstraintException((Object)idTag.length(), ERROR_MESSAGE);
        }
        this.idTag = idTag;
    }

    public String getParentIdTag() {
        return this.parentIdTag;
    }

    @XmlElement
    public void setParentIdTag(String parentIdTag) {
        if (!ModelUtil.validate((String)parentIdTag, (int)20)) {
            throw new PropertyConstraintException((Object)parentIdTag.length(), ERROR_MESSAGE);
        }
        this.parentIdTag = parentIdTag;
    }

    public Integer getReservationId() {
        return this.reservationId;
    }

    @XmlElement
    public void setReservationId(Integer reservationId) {
        this.reservationId = reservationId;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReserveNowRequest that = (ReserveNowRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.expiryDate, that.expiryDate) && Objects.equals(this.idTag, that.idTag) && Objects.equals(this.parentIdTag, that.parentIdTag) && Objects.equals(this.reservationId, that.reservationId);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.expiryDate, this.idTag, this.parentIdTag, this.reservationId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("expiryDate", this.expiryDate).add("idTag", (Object)this.idTag).add("parentIdTag", (Object)this.parentIdTag).add("reservationId", (Object)this.reservationId).add("isValid", this.validate()).toString();
    }
}

