/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.smartcharging;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.ChargingProfilePurposeType;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ClearChargingProfileRequest
implements Request {
    private Integer id;
    private Integer connectorId;
    private ChargingProfilePurposeType chargingProfilePurpose;
    private Integer stackLevel;

    public Integer getId() {
        return this.id;
    }

    @XmlElement
    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId != null && connectorId < 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be >= 0");
        }
        this.connectorId = connectorId;
    }

    public ChargingProfilePurposeType getChargingProfilePurpose() {
        return this.chargingProfilePurpose;
    }

    @XmlElement
    public void setChargingProfilePurpose(ChargingProfilePurposeType chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
    }

    public Integer getStackLevel() {
        return this.stackLevel;
    }

    @XmlElement
    public void setStackLevel(Integer stackLevel) {
        if (stackLevel != null && stackLevel < 0) {
            throw new PropertyConstraintException((Object)stackLevel, "stackLevel must be >= 0");
        }
        this.stackLevel = stackLevel;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean validate() {
        boolean valid = this.connectorId == null || this.connectorId >= 0;
        return valid &= this.stackLevel == null || this.stackLevel >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearChargingProfileRequest that = (ClearChargingProfileRequest)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.connectorId, that.connectorId) && Objects.equals((Object)this.chargingProfilePurpose, (Object)that.chargingProfilePurpose) && Objects.equals(this.stackLevel, that.stackLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.connectorId, this.chargingProfilePurpose, this.stackLevel});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("connectorId", (Object)this.connectorId).add("chargingProfilePurpose", (Object)this.chargingProfilePurpose).add("stackLevel", (Object)this.stackLevel).add("isValid", this.validate()).toString();
    }
}

