/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.smartcharging;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.smartcharging.ChargingRateUnitType;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class GetCompositeScheduleRequest
implements Request {
    private Integer connectorId;
    private Integer duration;
    private ChargingRateUnitType chargingRateUnit;

    @Deprecated
    public GetCompositeScheduleRequest() {
    }

    public GetCompositeScheduleRequest(Integer connectorId, Integer duration) {
        this.setConnectorId(connectorId);
        this.setDuration(duration);
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId == null || connectorId < 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be >= 0");
        }
        this.connectorId = connectorId;
    }

    public Integer getDuration() {
        return this.duration;
    }

    @XmlElement
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public ChargingRateUnitType getChargingRateUnit() {
        return this.chargingRateUnit;
    }

    @XmlElement
    public void setChargingRateUnit(ChargingRateUnitType chargingRateUnit) {
        this.chargingRateUnit = chargingRateUnit;
    }

    public boolean validate() {
        boolean valid = this.connectorId != null && this.connectorId >= 0;
        return valid &= this.duration != null;
    }

    public boolean transactionRelated() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectorId, this.duration, this.chargingRateUnit});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("duration", (Object)this.duration).add("chargingRateUnit", (Object)this.chargingRateUnit).add("isValid", this.validate()).toString();
    }
}

