/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.smartcharging;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.ChargingProfile;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SetChargingProfileRequest
implements Request {
    private Integer connectorId;
    private ChargingProfile csChargingProfiles;

    @Deprecated
    public SetChargingProfileRequest() {
    }

    public SetChargingProfileRequest(Integer connectorId, ChargingProfile chargingProfile) {
        this.setConnectorId(connectorId);
        this.setCsChargingProfiles(chargingProfile);
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId == null || connectorId < 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be >= 0");
        }
        this.connectorId = connectorId;
    }

    public ChargingProfile getCsChargingProfiles() {
        return this.csChargingProfiles;
    }

    @XmlElement(name="csChargingProfiles")
    public void setCsChargingProfiles(ChargingProfile csChargingProfiles) {
        this.csChargingProfiles = csChargingProfiles;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.connectorId != null && this.connectorId >= 0;
        if (this.csChargingProfiles != null) {
            valid &= this.csChargingProfiles.validate();
        }
        return valid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetChargingProfileRequest that = (SetChargingProfileRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.csChargingProfiles, that.csChargingProfiles);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.csChargingProfiles);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("csChargingProfiles", (Object)this.csChargingProfiles).add("isValid", this.validate()).toString();
    }
}

