/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import eu.europa.ec.eudi.openid4vci.CanExpire;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0003\u0007\b\tR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Leu/europa/ec/eudi/openid4vci/AccessToken;", "Leu/europa/ec/eudi/openid4vci/CanExpire;", "Ljava/io/Serializable;", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "Bearer", "DPoP", "Companion", "Leu/europa/ec/eudi/openid4vci/AccessToken$Bearer;", "Leu/europa/ec/eudi/openid4vci/AccessToken$DPoP;", "eudi-lib-jvm-openid4vci-kt"})
public interface AccessToken
extends CanExpire,
Serializable {
    @NotNull
    public static final Companion Companion = eu.europa.ec.eudi.openid4vci.AccessToken$Companion.$$INSTANCE;

    @NotNull
    public String getAccessToken();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Leu/europa/ec/eudi/openid4vci/AccessToken$Bearer;", "Leu/europa/ec/eudi/openid4vci/AccessToken;", "accessToken", "", "expiresIn", "Ljava/time/Duration;", "<init>", "(Ljava/lang/String;Ljava/time/Duration;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-openid4vci-kt"})
    @SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\neu/europa/ec/eudi/openid4vci/AccessToken$Bearer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
    public static final class Bearer
    implements AccessToken {
        @NotNull
        private final String accessToken;
        @Nullable
        private final Duration expiresIn;

        public Bearer(@NotNull String accessToken, @Nullable Duration expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            Companion.requireNotEmpty(this.getAccessToken());
            if (this.getExpiresIn() != null && !(!this.getExpiresIn().isNegative())) {
                boolean bl = false;
                String string = "Expires In should be positive";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        @Nullable
        public Duration getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @Nullable
        public final Duration component2() {
            return this.expiresIn;
        }

        @NotNull
        public final Bearer copy(@NotNull String accessToken, @Nullable Duration expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new Bearer(accessToken, expiresIn);
        }

        public static /* synthetic */ Bearer copy$default(Bearer bearer, String string, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                string = bearer.accessToken;
            }
            if ((n & 2) != 0) {
                duration = bearer.expiresIn;
            }
            return bearer.copy(string, duration);
        }

        @NotNull
        public String toString() {
            return "Bearer(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ")";
        }

        public int hashCode() {
            int result = this.accessToken.hashCode();
            result = result * 31 + (this.expiresIn == null ? 0 : this.expiresIn.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bearer)) {
                return false;
            }
            Bearer bearer = (Bearer)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)bearer.accessToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiresIn, (Object)bearer.expiresIn);
        }

        @Override
        public boolean isExpired(@NotNull Instant issued, @NotNull Instant at) {
            return DefaultImpls.isExpired(this, issued, at);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/openid4vci/AccessToken$Companion;", "", "<init>", "()V", "invoke", "Leu/europa/ec/eudi/openid4vci/AccessToken;", "accessToken", "", "expiresInSec", "", "useDPoP", "", "(Ljava/lang/String;Ljava/lang/Long;Z)Leu/europa/ec/eudi/openid4vci/AccessToken;", "requireNotEmpty", "", "eudi-lib-jvm-openid4vci-kt"})
    @SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\neu/europa/ec/eudi/openid4vci/AccessToken$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final AccessToken invoke(@NotNull String accessToken, @Nullable Long expiresInSec, boolean useDPoP) {
            Duration duration;
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.requireNotEmpty(accessToken);
            Long l = expiresInSec;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                duration = Duration.ofSeconds(it);
            } else {
                duration = null;
            }
            Duration expiresIn = duration;
            return useDPoP ? (AccessToken)new DPoP(accessToken, expiresIn) : (AccessToken)new Bearer(accessToken, expiresIn);
        }

        private final void requireNotEmpty(String accessToken) {
            if (!(((CharSequence)accessToken).length() > 0)) {
                boolean bl = false;
                String string = "Access Token must not be empty";
                throw new IllegalArgumentException(string.toString());
            }
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Leu/europa/ec/eudi/openid4vci/AccessToken$DPoP;", "Leu/europa/ec/eudi/openid4vci/AccessToken;", "accessToken", "", "expiresIn", "Ljava/time/Duration;", "<init>", "(Ljava/lang/String;Ljava/time/Duration;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-openid4vci-kt"})
    @SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\neu/europa/ec/eudi/openid4vci/AccessToken$DPoP\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
    public static final class DPoP
    implements AccessToken {
        @NotNull
        private final String accessToken;
        @Nullable
        private final Duration expiresIn;

        public DPoP(@NotNull String accessToken, @Nullable Duration expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            Companion.requireNotEmpty(this.getAccessToken());
            if (this.getExpiresIn() != null && !(!this.getExpiresIn().isNegative())) {
                boolean bl = false;
                String string = "Expires In should be positive";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        @Nullable
        public Duration getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @Nullable
        public final Duration component2() {
            return this.expiresIn;
        }

        @NotNull
        public final DPoP copy(@NotNull String accessToken, @Nullable Duration expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new DPoP(accessToken, expiresIn);
        }

        public static /* synthetic */ DPoP copy$default(DPoP dPoP, String string, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                string = dPoP.accessToken;
            }
            if ((n & 2) != 0) {
                duration = dPoP.expiresIn;
            }
            return dPoP.copy(string, duration);
        }

        @NotNull
        public String toString() {
            return "DPoP(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ")";
        }

        public int hashCode() {
            int result = this.accessToken.hashCode();
            result = result * 31 + (this.expiresIn == null ? 0 : this.expiresIn.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DPoP)) {
                return false;
            }
            DPoP dPoP = (DPoP)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)dPoP.accessToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiresIn, (Object)dPoP.expiresIn);
        }

        @Override
        public boolean isExpired(@NotNull Instant issued, @NotNull Instant at) {
            return DefaultImpls.isExpired(this, issued, at);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isExpired(@NotNull AccessToken $this, @NotNull Instant issued, @NotNull Instant at) {
            Intrinsics.checkNotNullParameter((Object)issued, (String)"issued");
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            return CanExpire.DefaultImpls.isExpired($this, issued, at);
        }
    }
}

