/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.jwk.JWK;
import eu.europa.ec.eudi.openid4vci.ClientAttestationKt;
import eu.europa.ec.eudi.openid4vci.Signer;
import eu.europa.ec.eudi.openid4vci.internal.SigningOpsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWTSpec;", "", "signer", "Leu/europa/ec/eudi/openid4vci/Signer;", "Lcom/nimbusds/jose/jwk/JWK;", "<init>", "(Leu/europa/ec/eudi/openid4vci/Signer;)V", "getSigner", "()Leu/europa/ec/eudi/openid4vci/Signer;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-openid4vci-kt"})
public final class ClientAttestationPoPJWTSpec {
    @NotNull
    private final Signer<JWK> signer;

    public ClientAttestationPoPJWTSpec(@NotNull Signer<? extends JWK> signer) {
        Intrinsics.checkNotNullParameter(signer, (String)"signer");
        this.signer = signer;
        ClientAttestationKt.requireIsNotMAC(SigningOpsKt.toJoseAlg(this.signer.getJavaAlgorithm()));
    }

    @NotNull
    public final Signer<JWK> getSigner() {
        return this.signer;
    }

    @NotNull
    public final Signer<JWK> component1() {
        return this.signer;
    }

    @NotNull
    public final ClientAttestationPoPJWTSpec copy(@NotNull Signer<? extends JWK> signer) {
        Intrinsics.checkNotNullParameter(signer, (String)"signer");
        return new ClientAttestationPoPJWTSpec(signer);
    }

    public static /* synthetic */ ClientAttestationPoPJWTSpec copy$default(ClientAttestationPoPJWTSpec clientAttestationPoPJWTSpec, Signer signer, int n, Object object) {
        if ((n & 1) != 0) {
            signer = clientAttestationPoPJWTSpec.signer;
        }
        return clientAttestationPoPJWTSpec.copy(signer);
    }

    @NotNull
    public String toString() {
        return "ClientAttestationPoPJWTSpec(signer=" + this.signer + ")";
    }

    public int hashCode() {
        return this.signer.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClientAttestationPoPJWTSpec)) {
            return false;
        }
        ClientAttestationPoPJWTSpec clientAttestationPoPJWTSpec = (ClientAttestationPoPJWTSpec)other;
        return Intrinsics.areEqual(this.signer, clientAttestationPoPJWTSpec.signer);
    }
}

