/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.JWSAlgorithm;
import eu.europa.ec.eudi.openid4vci.ProofType;
import eu.europa.ec.eudi.openid4vci.ProofTypeMeta;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0010\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002*\n\u0010\u0006\"\u00020\u00072\u00020\u0007\u00a8\u0006\b"}, d2={"type", "Leu/europa/ec/eudi/openid4vci/ProofType;", "Leu/europa/ec/eudi/openid4vci/ProofTypeMeta;", "algorithms", "", "Lcom/nimbusds/jose/JWSAlgorithm;", "CssColor", "", "eudi-lib-jvm-openid4vci-kt"})
public final class CredentialConfigurationKt {
    @Nullable
    public static final ProofType type(@NotNull ProofTypeMeta $this$type) {
        ProofType proofType;
        Intrinsics.checkNotNullParameter((Object)$this$type, (String)"<this>");
        ProofTypeMeta proofTypeMeta = $this$type;
        if (proofTypeMeta instanceof ProofTypeMeta.Jwt) {
            proofType = ProofType.JWT;
        } else if (proofTypeMeta instanceof ProofTypeMeta.DiVp) {
            proofType = ProofType.DI_VP;
        } else if (proofTypeMeta instanceof ProofTypeMeta.Attestation) {
            proofType = ProofType.ATTESTATION;
        } else if (proofTypeMeta instanceof ProofTypeMeta.Unsupported) {
            proofType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return proofType;
    }

    @NotNull
    public static final List<JWSAlgorithm> algorithms(@NotNull ProofTypeMeta $this$algorithms) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$algorithms, (String)"<this>");
        ProofTypeMeta proofTypeMeta = $this$algorithms;
        if (proofTypeMeta instanceof ProofTypeMeta.Jwt) {
            list = ((ProofTypeMeta.Jwt)$this$algorithms).getAlgorithms();
        } else if (proofTypeMeta instanceof ProofTypeMeta.Attestation) {
            list = ((ProofTypeMeta.Attestation)$this$algorithms).getAlgorithms();
        } else if (proofTypeMeta instanceof ProofTypeMeta.DiVp) {
            list = CollectionsKt.emptyList();
        } else if (proofTypeMeta instanceof ProofTypeMeta.Unsupported) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }
}

