/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.jwk.Curve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/openid4vci/EcConfig;", "", "ecKeyCurve", "Lcom/nimbusds/jose/jwk/Curve;", "supportedJWEAlgorithms", "", "Lcom/nimbusds/jose/JWEAlgorithm;", "<init>", "(Lcom/nimbusds/jose/jwk/Curve;Ljava/util/List;)V", "getEcKeyCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getSupportedJWEAlgorithms", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vci/EcConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1#2:249\n827#3:250\n855#3,2:251\n1669#3,8:253\n*S KotlinDebug\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vci/EcConfig\n*L\n212#1:250\n212#1:251,2\n216#1:253,8\n*E\n"})
public final class EcConfig {
    @NotNull
    private final Curve ecKeyCurve;
    @NotNull
    private final List<JWEAlgorithm> supportedJWEAlgorithms;

    /*
     * WARNING - void declaration
     */
    public EcConfig(@NotNull Curve ecKeyCurve, @NotNull List<JWEAlgorithm> supportedJWEAlgorithms) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ecKeyCurve, (String)"ecKeyCurve");
        Intrinsics.checkNotNullParameter(supportedJWEAlgorithms, (String)"supportedJWEAlgorithms");
        this.ecKeyCurve = ecKeyCurve;
        this.supportedJWEAlgorithms = supportedJWEAlgorithms;
        if (!(!((Collection)this.supportedJWEAlgorithms).isEmpty())) {
            boolean $i$a$-require-EcConfig$32 = false;
            String $i$a$-require-EcConfig$32 = "At least one encryption algorithm must be provided";
            throw new IllegalArgumentException($i$a$-require-EcConfig$32.toString());
        }
        Iterable $this$filterNot$iv = this.supportedJWEAlgorithms;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            JWEAlgorithm it = (JWEAlgorithm)element$iv$iv;
            boolean bl = false;
            if (ECDHEncrypter.SUPPORTED_ALGORITHMS.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsupportedJWEAlgorithms = (List)destination$iv$iv;
        if (!unsupportedJWEAlgorithms.isEmpty()) {
            boolean $i$a$-require-EcConfig$52 = false;
            String $i$a$-require-EcConfig$52 = "Unsupported encryption algorithms: " + CollectionsKt.joinToString$default((Iterable)unsupportedJWEAlgorithms, (CharSequence)", ", null, null, (int)0, null, EcConfig::lambda$3$lambda$2, (int)30, null);
            throw new IllegalArgumentException($i$a$-require-EcConfig$52.toString());
        }
        Iterable $this$distinctBy$iv = this.supportedJWEAlgorithms;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JWEAlgorithm it = (JWEAlgorithm)e$iv;
            boolean bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        if (!(((List)list$iv).size() == this.supportedJWEAlgorithms.size())) {
            boolean bl = false;
            String string = "supportedJWEAlgorithms contains duplicate values";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ EcConfig(Curve curve, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Set set = ECDHEncrypter.SUPPORTED_ALGORITHMS;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SUPPORTED_ALGORITHMS");
            list = CollectionsKt.toList((Iterable)set);
        }
        this(curve, list);
    }

    @NotNull
    public final Curve getEcKeyCurve() {
        return this.ecKeyCurve;
    }

    @NotNull
    public final List<JWEAlgorithm> getSupportedJWEAlgorithms() {
        return this.supportedJWEAlgorithms;
    }

    @NotNull
    public final Curve component1() {
        return this.ecKeyCurve;
    }

    @NotNull
    public final List<JWEAlgorithm> component2() {
        return this.supportedJWEAlgorithms;
    }

    @NotNull
    public final EcConfig copy(@NotNull Curve ecKeyCurve, @NotNull List<JWEAlgorithm> supportedJWEAlgorithms) {
        Intrinsics.checkNotNullParameter((Object)ecKeyCurve, (String)"ecKeyCurve");
        Intrinsics.checkNotNullParameter(supportedJWEAlgorithms, (String)"supportedJWEAlgorithms");
        return new EcConfig(ecKeyCurve, supportedJWEAlgorithms);
    }

    public static /* synthetic */ EcConfig copy$default(EcConfig ecConfig, Curve curve, List list, int n, Object object) {
        if ((n & 1) != 0) {
            curve = ecConfig.ecKeyCurve;
        }
        if ((n & 2) != 0) {
            list = ecConfig.supportedJWEAlgorithms;
        }
        return ecConfig.copy(curve, list);
    }

    @NotNull
    public String toString() {
        return "EcConfig(ecKeyCurve=" + this.ecKeyCurve + ", supportedJWEAlgorithms=" + this.supportedJWEAlgorithms + ")";
    }

    public int hashCode() {
        int result = this.ecKeyCurve.hashCode();
        result = result * 31 + ((Object)this.supportedJWEAlgorithms).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EcConfig)) {
            return false;
        }
        EcConfig ecConfig = (EcConfig)other;
        if (!Intrinsics.areEqual((Object)this.ecKeyCurve, (Object)ecConfig.ecKeyCurve)) {
            return false;
        }
        return Intrinsics.areEqual(this.supportedJWEAlgorithms, ecConfig.supportedJWEAlgorithms);
    }

    private static final CharSequence lambda$3$lambda$2(JWEAlgorithm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

