/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.jwk.Curve;
import eu.europa.ec.eudi.openid4vci.CredentialResponseEncryptionPolicy;
import eu.europa.ec.eudi.openid4vci.EcConfig;
import eu.europa.ec.eudi.openid4vci.RsaConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(BE\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003JM\u0010 \u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006)"}, d2={"Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "", "compressionAlgorithms", "", "Lcom/nimbusds/jose/CompressionAlgorithm;", "credentialResponseEncryptionPolicy", "Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryptionPolicy;", "ecConfig", "Leu/europa/ec/eudi/openid4vci/EcConfig;", "rsaConfig", "Leu/europa/ec/eudi/openid4vci/RsaConfig;", "supportedEncryptionMethods", "Lcom/nimbusds/jose/EncryptionMethod;", "<init>", "(Ljava/util/List;Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryptionPolicy;Leu/europa/ec/eudi/openid4vci/EcConfig;Leu/europa/ec/eudi/openid4vci/RsaConfig;Ljava/util/List;)V", "getCompressionAlgorithms", "()Ljava/util/List;", "getCredentialResponseEncryptionPolicy", "()Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryptionPolicy;", "getEcConfig", "()Leu/europa/ec/eudi/openid4vci/EcConfig;", "getRsaConfig", "()Leu/europa/ec/eudi/openid4vci/RsaConfig;", "getSupportedEncryptionMethods", "supportedEncryptionAlgorithms", "Lcom/nimbusds/jose/JWEAlgorithm;", "getSupportedEncryptionAlgorithms", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vci/EncryptionSupportConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1#2:249\n827#3:250\n855#3,2:251\n1669#3,8:253\n*S KotlinDebug\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vci/EncryptionSupportConfig\n*L\n163#1:250\n163#1:251,2\n167#1:253,8\n*E\n"})
public final class EncryptionSupportConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<CompressionAlgorithm> compressionAlgorithms;
    @NotNull
    private final CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy;
    @Nullable
    private final EcConfig ecConfig;
    @Nullable
    private final RsaConfig rsaConfig;
    @NotNull
    private final List<EncryptionMethod> supportedEncryptionMethods;

    /*
     * WARNING - void declaration
     */
    public EncryptionSupportConfig(@Nullable List<CompressionAlgorithm> compressionAlgorithms, @NotNull CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy, @Nullable EcConfig ecConfig, @Nullable RsaConfig rsaConfig, @NotNull List<EncryptionMethod> supportedEncryptionMethods) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)credentialResponseEncryptionPolicy), (String)"credentialResponseEncryptionPolicy");
        Intrinsics.checkNotNullParameter(supportedEncryptionMethods, (String)"supportedEncryptionMethods");
        this.compressionAlgorithms = compressionAlgorithms;
        this.credentialResponseEncryptionPolicy = credentialResponseEncryptionPolicy;
        this.ecConfig = ecConfig;
        this.rsaConfig = rsaConfig;
        this.supportedEncryptionMethods = supportedEncryptionMethods;
        if (!(!((Collection)this.supportedEncryptionMethods).isEmpty())) {
            boolean $i$a$-require-EncryptionSupportConfig$32 = false;
            String $i$a$-require-EncryptionSupportConfig$32 = "At least one encryption method must be provided";
            throw new IllegalArgumentException($i$a$-require-EncryptionSupportConfig$32.toString());
        }
        Iterable $this$filterNot$iv = this.supportedEncryptionMethods;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            EncryptionMethod it = (EncryptionMethod)element$iv$iv;
            boolean bl = false;
            if (ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsupportedEncryptionMethods = (List)destination$iv$iv;
        if (!unsupportedEncryptionMethods.isEmpty()) {
            boolean $i$a$-require-EncryptionSupportConfig$52 = false;
            String $i$a$-require-EncryptionSupportConfig$52 = "Unsupported encryption methods: " + CollectionsKt.joinToString$default((Iterable)unsupportedEncryptionMethods, (CharSequence)", ", null, null, (int)0, null, EncryptionSupportConfig::lambda$3$lambda$2, (int)30, null);
            throw new IllegalArgumentException($i$a$-require-EncryptionSupportConfig$52.toString());
        }
        Iterable $this$distinctBy$iv = this.supportedEncryptionMethods;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            EncryptionMethod it = (EncryptionMethod)e$iv;
            boolean bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        if (!(((List)list$iv).size() == this.supportedEncryptionMethods.size())) {
            boolean bl = false;
            String string = "supportedEncryptionMethods contains duplicate values";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ EncryptionSupportConfig(List list, CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy, EcConfig ecConfig, RsaConfig rsaConfig, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)CompressionAlgorithm.DEF);
        }
        if ((n & 0x10) != 0) {
            Set set = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SUPPORTED_ENCRYPTION_METHODS");
            list2 = CollectionsKt.toList((Iterable)set);
        }
        this(list, credentialResponseEncryptionPolicy, ecConfig, rsaConfig, list2);
    }

    @Nullable
    public final List<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    @NotNull
    public final CredentialResponseEncryptionPolicy getCredentialResponseEncryptionPolicy() {
        return this.credentialResponseEncryptionPolicy;
    }

    @Nullable
    public final EcConfig getEcConfig() {
        return this.ecConfig;
    }

    @Nullable
    public final RsaConfig getRsaConfig() {
        return this.rsaConfig;
    }

    @NotNull
    public final List<EncryptionMethod> getSupportedEncryptionMethods() {
        return this.supportedEncryptionMethods;
    }

    @NotNull
    public final List<JWEAlgorithm> getSupportedEncryptionAlgorithms() {
        List list;
        block1: {
            Object object;
            Object it;
            List $this$_get_supportedEncryptionAlgorithms__u24lambda_u248 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Object object2 = this.ecConfig;
            if (object2 != null && (object2 = ((EcConfig)object2).getSupportedJWEAlgorithms()) != null) {
                it = object2;
                boolean bl2 = false;
                $this$_get_supportedEncryptionAlgorithms__u24lambda_u248.addAll((Collection)it);
            }
            if ((object = this.rsaConfig) == null || (object = ((RsaConfig)object).getSupportedJWEAlgorithms()) == null) break block1;
            it = object;
            boolean bl3 = false;
            $this$_get_supportedEncryptionAlgorithms__u24lambda_u248.addAll((Collection)it);
        }
        return CollectionsKt.build((List)list);
    }

    @Nullable
    public final List<CompressionAlgorithm> component1() {
        return this.compressionAlgorithms;
    }

    @NotNull
    public final CredentialResponseEncryptionPolicy component2() {
        return this.credentialResponseEncryptionPolicy;
    }

    @Nullable
    public final EcConfig component3() {
        return this.ecConfig;
    }

    @Nullable
    public final RsaConfig component4() {
        return this.rsaConfig;
    }

    @NotNull
    public final List<EncryptionMethod> component5() {
        return this.supportedEncryptionMethods;
    }

    @NotNull
    public final EncryptionSupportConfig copy(@Nullable List<CompressionAlgorithm> compressionAlgorithms, @NotNull CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy, @Nullable EcConfig ecConfig, @Nullable RsaConfig rsaConfig, @NotNull List<EncryptionMethod> supportedEncryptionMethods) {
        Intrinsics.checkNotNullParameter((Object)((Object)credentialResponseEncryptionPolicy), (String)"credentialResponseEncryptionPolicy");
        Intrinsics.checkNotNullParameter(supportedEncryptionMethods, (String)"supportedEncryptionMethods");
        return new EncryptionSupportConfig(compressionAlgorithms, credentialResponseEncryptionPolicy, ecConfig, rsaConfig, supportedEncryptionMethods);
    }

    public static /* synthetic */ EncryptionSupportConfig copy$default(EncryptionSupportConfig encryptionSupportConfig, List list, CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy, EcConfig ecConfig, RsaConfig rsaConfig, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = encryptionSupportConfig.compressionAlgorithms;
        }
        if ((n & 2) != 0) {
            credentialResponseEncryptionPolicy = encryptionSupportConfig.credentialResponseEncryptionPolicy;
        }
        if ((n & 4) != 0) {
            ecConfig = encryptionSupportConfig.ecConfig;
        }
        if ((n & 8) != 0) {
            rsaConfig = encryptionSupportConfig.rsaConfig;
        }
        if ((n & 0x10) != 0) {
            list2 = encryptionSupportConfig.supportedEncryptionMethods;
        }
        return encryptionSupportConfig.copy(list, credentialResponseEncryptionPolicy, ecConfig, rsaConfig, list2);
    }

    @NotNull
    public String toString() {
        return "EncryptionSupportConfig(compressionAlgorithms=" + this.compressionAlgorithms + ", credentialResponseEncryptionPolicy=" + this.credentialResponseEncryptionPolicy + ", ecConfig=" + this.ecConfig + ", rsaConfig=" + this.rsaConfig + ", supportedEncryptionMethods=" + this.supportedEncryptionMethods + ")";
    }

    public int hashCode() {
        int result = this.compressionAlgorithms == null ? 0 : ((Object)this.compressionAlgorithms).hashCode();
        result = result * 31 + this.credentialResponseEncryptionPolicy.hashCode();
        result = result * 31 + (this.ecConfig == null ? 0 : this.ecConfig.hashCode());
        result = result * 31 + (this.rsaConfig == null ? 0 : this.rsaConfig.hashCode());
        result = result * 31 + ((Object)this.supportedEncryptionMethods).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionSupportConfig)) {
            return false;
        }
        EncryptionSupportConfig encryptionSupportConfig = (EncryptionSupportConfig)other;
        if (!Intrinsics.areEqual(this.compressionAlgorithms, encryptionSupportConfig.compressionAlgorithms)) {
            return false;
        }
        if (this.credentialResponseEncryptionPolicy != encryptionSupportConfig.credentialResponseEncryptionPolicy) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ecConfig, (Object)encryptionSupportConfig.ecConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rsaConfig, (Object)encryptionSupportConfig.rsaConfig)) {
            return false;
        }
        return Intrinsics.areEqual(this.supportedEncryptionMethods, encryptionSupportConfig.supportedEncryptionMethods);
    }

    private static final CharSequence lambda$3$lambda$2(EncryptionMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig$Companion;", "", "<init>", "()V", "invoke", "Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "ecKeyCurve", "Lcom/nimbusds/jose/jwk/Curve;", "rcaKeySize", "", "credentialResponseEncryptionPolicy", "Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryptionPolicy;", "eudi-lib-jvm-openid4vci-kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EncryptionSupportConfig invoke(@NotNull Curve ecKeyCurve, int rcaKeySize, @NotNull CredentialResponseEncryptionPolicy credentialResponseEncryptionPolicy) {
            Intrinsics.checkNotNullParameter((Object)ecKeyCurve, (String)"ecKeyCurve");
            Intrinsics.checkNotNullParameter((Object)((Object)credentialResponseEncryptionPolicy), (String)"credentialResponseEncryptionPolicy");
            EcConfig ecConfig = new EcConfig(ecKeyCurve, null, 2, null);
            RsaConfig rsaConfig = new RsaConfig(rcaKeySize, null, 2, null);
            return new EncryptionSupportConfig(null, credentialResponseEncryptionPolicy, ecConfig, rsaConfig, null, 17, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

