/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci.internal;

import com.nimbusds.jose.CompressionAlgorithm;
import eu.europa.ec.eudi.openid4vci.CredentialIssuanceError;
import eu.europa.ec.eudi.openid4vci.CredentialIssuerMetadata;
import eu.europa.ec.eudi.openid4vci.CredentialRequestEncryption;
import eu.europa.ec.eudi.openid4vci.CredentialResponseEncryption;
import eu.europa.ec.eudi.openid4vci.CredentialResponseEncryptionPolicy;
import eu.europa.ec.eudi.openid4vci.EncryptionSpec;
import eu.europa.ec.eudi.openid4vci.EncryptionSupportConfig;
import eu.europa.ec.eudi.openid4vci.ExchangeEncryptionSpecification;
import eu.europa.ec.eudi.openid4vci.PayloadCompression;
import eu.europa.ec.eudi.openid4vci.RequestEncryptionSpecFactory;
import eu.europa.ec.eudi.openid4vci.ResponseEncryptionSpecFactory;
import eu.europa.ec.eudi.openid4vci.SupportedRequestEncryptionParameters;
import eu.europa.ec.eudi.openid4vci.SupportedResponseEncryptionParameters;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a3\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a-\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a-\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"issuanceEncryptionSpecs", "Lkotlin/Result;", "Leu/europa/ec/eudi/openid4vci/ExchangeEncryptionSpecification;", "encryptionSupportConfig", "Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "issuerMetadata", "Leu/europa/ec/eudi/openid4vci/CredentialIssuerMetadata;", "requestEncryptionSpecFactory", "Leu/europa/ec/eudi/openid4vci/RequestEncryptionSpecFactory;", "responseEncryptionSpecFactory", "Leu/europa/ec/eudi/openid4vci/ResponseEncryptionSpecFactory;", "(Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;Leu/europa/ec/eudi/openid4vci/CredentialIssuerMetadata;Leu/europa/ec/eudi/openid4vci/RequestEncryptionSpecFactory;Leu/europa/ec/eudi/openid4vci/ResponseEncryptionSpecFactory;)Ljava/lang/Object;", "responseEncryptionSpec", "Leu/europa/ec/eudi/openid4vci/EncryptionSpec;", "issuerSupportedCredentialResponseEncryption", "Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryption;", "walletEncryptionSupportConfig", "(Leu/europa/ec/eudi/openid4vci/CredentialResponseEncryption;Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;Leu/europa/ec/eudi/openid4vci/ResponseEncryptionSpecFactory;)Ljava/lang/Object;", "requestEncryptionSpec", "issuerSupportedCredentialRequestEncryption", "Leu/europa/ec/eudi/openid4vci/CredentialRequestEncryption;", "(Leu/europa/ec/eudi/openid4vci/CredentialRequestEncryption;Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;Leu/europa/ec/eudi/openid4vci/RequestEncryptionSpecFactory;)Ljava/lang/Object;", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nIssuanceEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssuanceEncryption.kt\neu/europa/ec/eudi/openid4vci/internal/IssuanceEncryptionKt\n+ 2 ResultOps.kt\neu/europa/ec/eudi/openid4vci/internal/ResultOpsKt\n*L\n1#1,209:1\n47#2,2:210\n47#2,2:212\n47#2,2:214\n39#2,2:216\n39#2,2:218\n39#2,2:220\n39#2,2:222\n39#2,2:224\n39#2,2:226\n39#2,2:228\n39#2,2:230\n*S KotlinDebug\n*F\n+ 1 IssuanceEncryption.kt\neu/europa/ec/eudi/openid4vci/internal/IssuanceEncryptionKt\n*L\n114#1:210,2\n132#1:212,2\n203#1:214,2\n71#1:216,2\n74#1:218,2\n78#1:220,2\n81#1:222,2\n164#1:224,2\n167#1:226,2\n171#1:228,2\n174#1:230,2\n*E\n"})
public final class IssuanceEncryptionKt {
    @NotNull
    public static final Object issuanceEncryptionSpecs(@NotNull EncryptionSupportConfig encryptionSupportConfig, @NotNull CredentialIssuerMetadata issuerMetadata, @NotNull RequestEncryptionSpecFactory requestEncryptionSpecFactory, @NotNull ResponseEncryptionSpecFactory responseEncryptionSpecFactory) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encryptionSupportConfig, (String)"encryptionSupportConfig");
        Intrinsics.checkNotNullParameter((Object)issuerMetadata, (String)"issuerMetadata");
        Intrinsics.checkNotNullParameter((Object)requestEncryptionSpecFactory, (String)"requestEncryptionSpecFactory");
        Intrinsics.checkNotNullParameter((Object)responseEncryptionSpecFactory, (String)"responseEncryptionSpecFactory");
        try {
            boolean bl = false;
            Object object2 = IssuanceEncryptionKt.requestEncryptionSpec(issuerMetadata.getCredentialRequestEncryption(), encryptionSupportConfig, requestEncryptionSpecFactory);
            ResultKt.throwOnFailure((Object)object2);
            EncryptionSpec requestEncryptionSpec = (EncryptionSpec)object2;
            Object object3 = IssuanceEncryptionKt.responseEncryptionSpec(issuerMetadata.getCredentialResponseEncryption(), encryptionSupportConfig, responseEncryptionSpecFactory);
            ResultKt.throwOnFailure((Object)object3);
            EncryptionSpec responseEncryptionSpec = (EncryptionSpec)object3;
            object = Result.constructor-impl((Object)new ExchangeEncryptionSpecification(requestEncryptionSpec, responseEncryptionSpec));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private static final Object responseEncryptionSpec(CredentialResponseEncryption issuerSupportedCredentialResponseEncryption, EncryptionSupportConfig walletEncryptionSupportConfig, ResponseEncryptionSpecFactory responseEncryptionSpecFactory) {
        Object object;
        try {
            EncryptionSpec encryptionSpec;
            block21: {
                CredentialResponseEncryption encryption;
                block22: {
                    Object $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22;
                    block20: {
                        boolean bl = false;
                        encryption = issuerSupportedCredentialResponseEncryption;
                        if (!Intrinsics.areEqual((Object)encryption, (Object)CredentialResponseEncryption.NotSupported.INSTANCE)) break block20;
                        switch (WhenMappings.$EnumSwitchMapping$0[walletEncryptionSupportConfig.getCredentialResponseEncryptionPolicy().ordinal()]) {
                            case 1: {
                                encryptionSpec = null;
                                break block21;
                            }
                            case 2: {
                                throw new CredentialIssuanceError.ResponseEncryptionError.ResponseEncryptionRequiredByWalletButNotSupportedByIssuer();
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!(encryption instanceof CredentialResponseEncryption.SupportedNotRequired)) break block22;
                    SupportedResponseEncryptionParameters supportedResponseEncryptionParameters = ((CredentialResponseEncryption.SupportedNotRequired)encryption).getEncryptionParameters();
                    try {
                        EncryptionSpec encryptionSpec2;
                        boolean $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22 = false;
                        EncryptionSpec encryptionSpec3 = responseEncryptionSpecFactory.make(supportedResponseEncryptionParameters, walletEncryptionSupportConfig);
                        if (encryptionSpec3 != null) {
                            EncryptionSpec encryptionSpec4;
                            EncryptionSpec $this$responseEncryptionSpec_u24lambda_u2411_u24lambda_u247_u24lambda_u246 = encryptionSpec4 = encryptionSpec3;
                            boolean bl = false;
                            IssuanceEncryptionKt.responseEncryptionSpec$lambda$11$validate($this$responseEncryptionSpec_u24lambda_u2411_u24lambda_u247_u24lambda_u246, supportedResponseEncryptionParameters);
                            encryptionSpec2 = encryptionSpec4;
                        } else {
                            encryptionSpec2 = null;
                        }
                        $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22 = Result.constructor-impl(encryptionSpec2);
                    }
                    catch (Throwable throwable) {
                        $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    EncryptionSpec maybeSpec = (EncryptionSpec)(Result.isFailure-impl((Object)$i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22) ? null : $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22);
                    switch (WhenMappings.$EnumSwitchMapping$0[walletEncryptionSupportConfig.getCredentialResponseEncryptionPolicy().ordinal()]) {
                        case 1: {
                            encryptionSpec = maybeSpec;
                            break block21;
                        }
                        case 2: {
                            boolean $i$f$ensureNotNull = false;
                            if (maybeSpec == null) {
                                boolean bl = false;
                                throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.WalletRequiresCredentialResponseEncryptionButNoCryptoMaterialCanBeGenerated();
                            }
                            encryptionSpec = maybeSpec;
                            break block21;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (encryption instanceof CredentialResponseEncryption.Required) {
                    EncryptionSpec encryptionSpec5;
                    SupportedResponseEncryptionParameters supportedResponseEncryptionParameters = ((CredentialResponseEncryption.Required)encryption).getEncryptionParameters();
                    EncryptionSpec $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22 = responseEncryptionSpecFactory.make(supportedResponseEncryptionParameters, walletEncryptionSupportConfig);
                    if ($i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22 != null) {
                        EncryptionSpec encryptionSpec6;
                        EncryptionSpec $this$responseEncryptionSpec_u24lambda_u2411_u24lambda_u249 = encryptionSpec6 = $i$a$-runCatching-IssuanceEncryptionKt$responseEncryptionSpec$1$maybeSpec$22;
                        boolean bl = false;
                        IssuanceEncryptionKt.responseEncryptionSpec$lambda$11$validate($this$responseEncryptionSpec_u24lambda_u2411_u24lambda_u249, supportedResponseEncryptionParameters);
                        encryptionSpec5 = encryptionSpec6;
                    } else {
                        encryptionSpec5 = null;
                    }
                    EncryptionSpec maybeSpec = encryptionSpec5;
                    boolean $i$f$ensureNotNull = false;
                    if (maybeSpec == null) {
                        boolean bl = false;
                        throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.IssuerExpectsResponseEncryptionCryptoMaterialButNotProvided();
                    }
                    encryptionSpec = maybeSpec;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object = Result.constructor-impl(encryptionSpec);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private static final Object requestEncryptionSpec(CredentialRequestEncryption issuerSupportedCredentialRequestEncryption, EncryptionSupportConfig walletEncryptionSupportConfig, RequestEncryptionSpecFactory requestEncryptionSpecFactory) {
        Object object;
        try {
            EncryptionSpec encryptionSpec;
            boolean bl = false;
            CredentialRequestEncryption encryption = issuerSupportedCredentialRequestEncryption;
            if (Intrinsics.areEqual((Object)encryption, (Object)CredentialRequestEncryption.NotSupported.INSTANCE)) {
                encryptionSpec = null;
            } else if (encryption instanceof CredentialRequestEncryption.SupportedNotRequired) {
                Object $i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22;
                SupportedRequestEncryptionParameters issuerSupportedRequestEncryptionParameters = ((CredentialRequestEncryption.SupportedNotRequired)encryption).getEncryptionParameters();
                try {
                    EncryptionSpec encryptionSpec2;
                    boolean $i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22 = false;
                    EncryptionSpec encryptionSpec3 = requestEncryptionSpecFactory.make(issuerSupportedRequestEncryptionParameters, walletEncryptionSupportConfig);
                    if (encryptionSpec3 != null) {
                        EncryptionSpec encryptionSpec4;
                        EncryptionSpec $this$requestEncryptionSpec_u24lambda_u2422_u24lambda_u2419_u24lambda_u2418 = encryptionSpec4 = encryptionSpec3;
                        boolean bl2 = false;
                        IssuanceEncryptionKt.requestEncryptionSpec$lambda$22$validate$17($this$requestEncryptionSpec_u24lambda_u2422_u24lambda_u2419_u24lambda_u2418, issuerSupportedRequestEncryptionParameters);
                        encryptionSpec2 = encryptionSpec4;
                    } else {
                        encryptionSpec2 = null;
                    }
                    $i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22 = Result.constructor-impl(encryptionSpec2);
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                encryptionSpec = (EncryptionSpec)(Result.isFailure-impl((Object)$i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22) ? null : $i$a$-runCatching-IssuanceEncryptionKt$requestEncryptionSpec$1$22);
            } else if (encryption instanceof CredentialRequestEncryption.Required) {
                EncryptionSpec encryptionSpec5;
                SupportedRequestEncryptionParameters issuerSupportedRequestEncryptionParameters = ((CredentialRequestEncryption.Required)encryption).getEncryptionParameters();
                EncryptionSpec encryptionSpec6 = requestEncryptionSpecFactory.make(issuerSupportedRequestEncryptionParameters, walletEncryptionSupportConfig);
                if (encryptionSpec6 != null) {
                    EncryptionSpec encryptionSpec7;
                    EncryptionSpec $this$requestEncryptionSpec_u24lambda_u2422_u24lambda_u2420 = encryptionSpec7 = encryptionSpec6;
                    boolean bl3 = false;
                    IssuanceEncryptionKt.requestEncryptionSpec$lambda$22$validate$17($this$requestEncryptionSpec_u24lambda_u2422_u24lambda_u2420, issuerSupportedRequestEncryptionParameters);
                    encryptionSpec5 = encryptionSpec7;
                } else {
                    encryptionSpec5 = null;
                }
                EncryptionSpec maybeSpec = encryptionSpec5;
                boolean $i$f$ensureNotNull = false;
                if (maybeSpec == null) {
                    boolean bl4 = false;
                    throw (Throwable)new CredentialIssuanceError.RequestEncryptionError.IssuerRequiresEncryptedRequestButEncryptionSpecCannotBeFormulated();
                }
                encryptionSpec = maybeSpec;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = Result.constructor-impl(encryptionSpec);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private static final void responseEncryptionSpec$lambda$11$validate(EncryptionSpec $this$responseEncryptionSpec_u24lambda_u2411_u24validate, SupportedResponseEncryptionParameters issuerSupportedResponseEncryptionParameters) {
        boolean value$iv = issuerSupportedResponseEncryptionParameters.getAlgorithms().contains($this$responseEncryptionSpec_u24lambda_u2411_u24validate.getAlgorithm());
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.ResponseEncryptionAlgorithmNotSupportedByIssuer();
        }
        value$iv = issuerSupportedResponseEncryptionParameters.getEncryptionMethods().contains($this$responseEncryptionSpec_u24lambda_u2411_u24validate.getEncryptionMethod());
        $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.ResponseEncryptionMethodNotSupportedByIssuer();
        }
        CompressionAlgorithm compressionAlgorithm = $this$responseEncryptionSpec_u24lambda_u2411_u24validate.getCompressionAlgorithm();
        if (compressionAlgorithm != null) {
            CompressionAlgorithm it = compressionAlgorithm;
            boolean bl = false;
            boolean value$iv2 = issuerSupportedResponseEncryptionParameters.getPayloadCompression() instanceof PayloadCompression.Supported;
            boolean $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl2 = false;
                throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.IssuerDoesNotSupportEncryptedPayloadCompression();
            }
            value$iv2 = ((PayloadCompression.Supported)issuerSupportedResponseEncryptionParameters.getPayloadCompression()).getAlgorithms().contains(it);
            $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl3 = false;
                throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.IssuerDoesNotSupportEncryptedPayloadCompressionAlgorithm();
            }
        }
    }

    private static final void requestEncryptionSpec$lambda$22$validate$17(EncryptionSpec $this$requestEncryptionSpec_u24lambda_u2422_u24validate_u2417, SupportedRequestEncryptionParameters issuerSupportedRequestEncryptionParameters) {
        boolean value$iv = issuerSupportedRequestEncryptionParameters.getEncryptionKeys().getKeys().contains($this$requestEncryptionSpec_u24lambda_u2422_u24validate_u2417.getRecipientKey());
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)new CredentialIssuanceError.RequestEncryptionError.RequestEncryptionKeyNotAnIssuerKey();
        }
        value$iv = issuerSupportedRequestEncryptionParameters.getEncryptionMethods().contains($this$requestEncryptionSpec_u24lambda_u2422_u24validate_u2417.getEncryptionMethod());
        $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)new CredentialIssuanceError.RequestEncryptionError.RequestEncryptionMethodNotSupportedByIssuer();
        }
        CompressionAlgorithm compressionAlgorithm = $this$requestEncryptionSpec_u24lambda_u2422_u24validate_u2417.getCompressionAlgorithm();
        if (compressionAlgorithm != null) {
            CompressionAlgorithm it = compressionAlgorithm;
            boolean bl = false;
            boolean value$iv2 = issuerSupportedRequestEncryptionParameters.getPayloadCompression() instanceof PayloadCompression.Supported;
            boolean $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl2 = false;
                throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.IssuerDoesNotSupportEncryptedPayloadCompression();
            }
            value$iv2 = ((PayloadCompression.Supported)issuerSupportedRequestEncryptionParameters.getPayloadCompression()).getAlgorithms().contains(it);
            $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl3 = false;
                throw (Throwable)new CredentialIssuanceError.ResponseEncryptionError.IssuerDoesNotSupportEncryptedPayloadCompressionAlgorithm();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CredentialResponseEncryptionPolicy.values().length];
            try {
                nArray[CredentialResponseEncryptionPolicy.SUPPORTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CredentialResponseEncryptionPolicy.REQUIRED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

