/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Leu/europa/ec/eudi/openid4vp/ResponseEncryptionSpecification;", "Ljava/io/Serializable;", "encryptionAlgorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "recipientKey", "Lcom/nimbusds/jose/jwk/JWK;", "<init>", "(Lcom/nimbusds/jose/JWEAlgorithm;Lcom/nimbusds/jose/EncryptionMethod;Lcom/nimbusds/jose/jwk/JWK;)V", "getEncryptionAlgorithm", "()Lcom/nimbusds/jose/JWEAlgorithm;", "getEncryptionMethod", "()Lcom/nimbusds/jose/EncryptionMethod;", "getRecipientKey", "()Lcom/nimbusds/jose/jwk/JWK;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
public final class ResponseEncryptionSpecification
implements Serializable {
    @NotNull
    private final JWEAlgorithm encryptionAlgorithm;
    @NotNull
    private final EncryptionMethod encryptionMethod;
    @NotNull
    private final JWK recipientKey;

    public ResponseEncryptionSpecification(@NotNull JWEAlgorithm encryptionAlgorithm, @NotNull EncryptionMethod encryptionMethod, @NotNull JWK recipientKey) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionMethod = encryptionMethod;
        this.recipientKey = recipientKey;
        Algorithm algorithm = this.recipientKey.getAlgorithm();
        if (!Intrinsics.areEqual((Object)this.encryptionAlgorithm.getName(), (Object)(algorithm != null ? algorithm.getName() : null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.recipientKey.getKeyID() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final JWEAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    @NotNull
    public final JWK getRecipientKey() {
        return this.recipientKey;
    }

    @NotNull
    public final JWEAlgorithm component1() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final EncryptionMethod component2() {
        return this.encryptionMethod;
    }

    @NotNull
    public final JWK component3() {
        return this.recipientKey;
    }

    @NotNull
    public final ResponseEncryptionSpecification copy(@NotNull JWEAlgorithm encryptionAlgorithm, @NotNull EncryptionMethod encryptionMethod, @NotNull JWK recipientKey) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        return new ResponseEncryptionSpecification(encryptionAlgorithm, encryptionMethod, recipientKey);
    }

    public static /* synthetic */ ResponseEncryptionSpecification copy$default(ResponseEncryptionSpecification responseEncryptionSpecification, JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod, JWK jWK, int n, Object object) {
        if ((n & 1) != 0) {
            jWEAlgorithm = responseEncryptionSpecification.encryptionAlgorithm;
        }
        if ((n & 2) != 0) {
            encryptionMethod = responseEncryptionSpecification.encryptionMethod;
        }
        if ((n & 4) != 0) {
            jWK = responseEncryptionSpecification.recipientKey;
        }
        return responseEncryptionSpecification.copy(jWEAlgorithm, encryptionMethod, jWK);
    }

    @NotNull
    public String toString() {
        return "ResponseEncryptionSpecification(encryptionAlgorithm=" + this.encryptionAlgorithm + ", encryptionMethod=" + this.encryptionMethod + ", recipientKey=" + this.recipientKey + ")";
    }

    public int hashCode() {
        int result = this.encryptionAlgorithm.hashCode();
        result = result * 31 + this.encryptionMethod.hashCode();
        result = result * 31 + this.recipientKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResponseEncryptionSpecification)) {
            return false;
        }
        ResponseEncryptionSpecification responseEncryptionSpecification = (ResponseEncryptionSpecification)other;
        if (!Intrinsics.areEqual((Object)this.encryptionAlgorithm, (Object)responseEncryptionSpecification.encryptionAlgorithm)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encryptionMethod, (Object)responseEncryptionSpecification.encryptionMethod)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.recipientKey, (Object)responseEncryptionSpecification.recipientKey);
    }
}

