/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import com.nimbusds.oauth2.sdk.id.Issuer;
import eu.europa.ec.eudi.openid4vp.ErrorDispatchPolicy;
import eu.europa.ec.eudi.openid4vp.JarConfiguration;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionConfiguration;
import eu.europa.ec.eudi.openid4vp.SupportedClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.VPConfiguration;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B[\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014Bc\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0015\"\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\tH\u00c6\u0003J\t\u0010+\u001a\u00020\u000bH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010.\u001a\u00020\u0012H\u00c6\u0003Ja\u0010/\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "", "issuer", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "jarConfiguration", "Leu/europa/ec/eudi/openid4vp/JarConfiguration;", "responseEncryptionConfiguration", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;", "vpConfiguration", "Leu/europa/ec/eudi/openid4vp/VPConfiguration;", "clock", "Ljava/time/Clock;", "jarClockSkew", "Ljava/time/Duration;", "supportedClientIdPrefixes", "", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "errorDispatchPolicy", "Leu/europa/ec/eudi/openid4vp/ErrorDispatchPolicy;", "<init>", "(Lcom/nimbusds/oauth2/sdk/id/Issuer;Leu/europa/ec/eudi/openid4vp/JarConfiguration;Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;Leu/europa/ec/eudi/openid4vp/VPConfiguration;Ljava/time/Clock;Ljava/time/Duration;Ljava/util/List;Leu/europa/ec/eudi/openid4vp/ErrorDispatchPolicy;)V", "", "(Lcom/nimbusds/oauth2/sdk/id/Issuer;Leu/europa/ec/eudi/openid4vp/JarConfiguration;Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;Leu/europa/ec/eudi/openid4vp/VPConfiguration;Ljava/time/Clock;Ljava/time/Duration;Leu/europa/ec/eudi/openid4vp/ErrorDispatchPolicy;[Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;)V", "getIssuer", "()Lcom/nimbusds/oauth2/sdk/id/Issuer;", "getJarConfiguration", "()Leu/europa/ec/eudi/openid4vp/JarConfiguration;", "getResponseEncryptionConfiguration", "()Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;", "getVpConfiguration", "()Leu/europa/ec/eudi/openid4vp/VPConfiguration;", "getClock", "()Ljava/time/Clock;", "getJarClockSkew", "()Ljava/time/Duration;", "getSupportedClientIdPrefixes", "()Ljava/util/List;", "getErrorDispatchPolicy", "()Leu/europa/ec/eudi/openid4vp/ErrorDispatchPolicy;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n1#2:432\n*E\n"})
public final class SiopOpenId4VPConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Issuer issuer;
    @NotNull
    private final JarConfiguration jarConfiguration;
    @NotNull
    private final ResponseEncryptionConfiguration responseEncryptionConfiguration;
    @NotNull
    private final VPConfiguration vpConfiguration;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Duration jarClockSkew;
    @NotNull
    private final List<SupportedClientIdPrefix> supportedClientIdPrefixes;
    @NotNull
    private final ErrorDispatchPolicy errorDispatchPolicy;
    @NotNull
    private static final Issuer SelfIssued = new Issuer(URI.create("https://self-issued.me/v2"));

    public SiopOpenId4VPConfig(@Nullable Issuer issuer, @NotNull JarConfiguration jarConfiguration, @NotNull ResponseEncryptionConfiguration responseEncryptionConfiguration, @NotNull VPConfiguration vpConfiguration, @NotNull Clock clock, @NotNull Duration jarClockSkew, @NotNull List<? extends SupportedClientIdPrefix> supportedClientIdPrefixes, @NotNull ErrorDispatchPolicy errorDispatchPolicy) {
        Intrinsics.checkNotNullParameter((Object)jarConfiguration, (String)"jarConfiguration");
        Intrinsics.checkNotNullParameter((Object)responseEncryptionConfiguration, (String)"responseEncryptionConfiguration");
        Intrinsics.checkNotNullParameter((Object)vpConfiguration, (String)"vpConfiguration");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jarClockSkew, (String)"jarClockSkew");
        Intrinsics.checkNotNullParameter(supportedClientIdPrefixes, (String)"supportedClientIdPrefixes");
        Intrinsics.checkNotNullParameter((Object)errorDispatchPolicy, (String)"errorDispatchPolicy");
        this.issuer = issuer;
        this.jarConfiguration = jarConfiguration;
        this.responseEncryptionConfiguration = responseEncryptionConfiguration;
        this.vpConfiguration = vpConfiguration;
        this.clock = clock;
        this.jarClockSkew = jarClockSkew;
        this.supportedClientIdPrefixes = supportedClientIdPrefixes;
        this.errorDispatchPolicy = errorDispatchPolicy;
        if (!(!((Collection)this.supportedClientIdPrefixes).isEmpty())) {
            boolean bl = false;
            String string = "At least a supported client id prefix must be provided";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SiopOpenId4VPConfig(Issuer issuer, JarConfiguration jarConfiguration, ResponseEncryptionConfiguration responseEncryptionConfiguration, VPConfiguration vPConfiguration, Clock clock, Duration duration, List list, ErrorDispatchPolicy errorDispatchPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            issuer = SelfIssued;
        }
        if ((n & 2) != 0) {
            jarConfiguration = JarConfiguration.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            responseEncryptionConfiguration = ResponseEncryptionConfiguration.NotSupported.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 0x20) != 0) {
            duration = Duration.ofSeconds(15L);
        }
        if ((n & 0x80) != 0) {
            errorDispatchPolicy = ErrorDispatchPolicy.OnlyAuthenticatedClients;
        }
        this(issuer, jarConfiguration, responseEncryptionConfiguration, vPConfiguration, clock, duration, list, errorDispatchPolicy);
    }

    @Nullable
    public final Issuer getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final JarConfiguration getJarConfiguration() {
        return this.jarConfiguration;
    }

    @NotNull
    public final ResponseEncryptionConfiguration getResponseEncryptionConfiguration() {
        return this.responseEncryptionConfiguration;
    }

    @NotNull
    public final VPConfiguration getVpConfiguration() {
        return this.vpConfiguration;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final Duration getJarClockSkew() {
        return this.jarClockSkew;
    }

    @NotNull
    public final List<SupportedClientIdPrefix> getSupportedClientIdPrefixes() {
        return this.supportedClientIdPrefixes;
    }

    @NotNull
    public final ErrorDispatchPolicy getErrorDispatchPolicy() {
        return this.errorDispatchPolicy;
    }

    public SiopOpenId4VPConfig(@Nullable Issuer issuer, @NotNull JarConfiguration jarConfiguration, @NotNull ResponseEncryptionConfiguration responseEncryptionConfiguration, @NotNull VPConfiguration vpConfiguration, @NotNull Clock clock, @NotNull Duration jarClockSkew, @NotNull ErrorDispatchPolicy errorDispatchPolicy, SupportedClientIdPrefix ... supportedClientIdPrefixes) {
        Intrinsics.checkNotNullParameter((Object)jarConfiguration, (String)"jarConfiguration");
        Intrinsics.checkNotNullParameter((Object)responseEncryptionConfiguration, (String)"responseEncryptionConfiguration");
        Intrinsics.checkNotNullParameter((Object)vpConfiguration, (String)"vpConfiguration");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jarClockSkew, (String)"jarClockSkew");
        Intrinsics.checkNotNullParameter((Object)errorDispatchPolicy, (String)"errorDispatchPolicy");
        Intrinsics.checkNotNullParameter((Object)supportedClientIdPrefixes, (String)"supportedClientIdPrefixes");
        this(issuer, jarConfiguration, responseEncryptionConfiguration, vpConfiguration, clock, jarClockSkew, ArraysKt.toList((Object[])supportedClientIdPrefixes), errorDispatchPolicy);
    }

    public /* synthetic */ SiopOpenId4VPConfig(Issuer issuer, JarConfiguration jarConfiguration, ResponseEncryptionConfiguration responseEncryptionConfiguration, VPConfiguration vPConfiguration, Clock clock, Duration duration, ErrorDispatchPolicy errorDispatchPolicy, SupportedClientIdPrefix[] supportedClientIdPrefixArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            issuer = SelfIssued;
        }
        if ((n & 2) != 0) {
            jarConfiguration = JarConfiguration.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            responseEncryptionConfiguration = ResponseEncryptionConfiguration.NotSupported.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 0x20) != 0) {
            duration = Duration.ofSeconds(15L);
        }
        if ((n & 0x40) != 0) {
            errorDispatchPolicy = ErrorDispatchPolicy.OnlyAuthenticatedClients;
        }
        this(issuer, jarConfiguration, responseEncryptionConfiguration, vPConfiguration, clock, duration, errorDispatchPolicy, supportedClientIdPrefixArray);
    }

    @Nullable
    public final Issuer component1() {
        return this.issuer;
    }

    @NotNull
    public final JarConfiguration component2() {
        return this.jarConfiguration;
    }

    @NotNull
    public final ResponseEncryptionConfiguration component3() {
        return this.responseEncryptionConfiguration;
    }

    @NotNull
    public final VPConfiguration component4() {
        return this.vpConfiguration;
    }

    @NotNull
    public final Clock component5() {
        return this.clock;
    }

    @NotNull
    public final Duration component6() {
        return this.jarClockSkew;
    }

    @NotNull
    public final List<SupportedClientIdPrefix> component7() {
        return this.supportedClientIdPrefixes;
    }

    @NotNull
    public final ErrorDispatchPolicy component8() {
        return this.errorDispatchPolicy;
    }

    @NotNull
    public final SiopOpenId4VPConfig copy(@Nullable Issuer issuer, @NotNull JarConfiguration jarConfiguration, @NotNull ResponseEncryptionConfiguration responseEncryptionConfiguration, @NotNull VPConfiguration vpConfiguration, @NotNull Clock clock, @NotNull Duration jarClockSkew, @NotNull List<? extends SupportedClientIdPrefix> supportedClientIdPrefixes, @NotNull ErrorDispatchPolicy errorDispatchPolicy) {
        Intrinsics.checkNotNullParameter((Object)jarConfiguration, (String)"jarConfiguration");
        Intrinsics.checkNotNullParameter((Object)responseEncryptionConfiguration, (String)"responseEncryptionConfiguration");
        Intrinsics.checkNotNullParameter((Object)vpConfiguration, (String)"vpConfiguration");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jarClockSkew, (String)"jarClockSkew");
        Intrinsics.checkNotNullParameter(supportedClientIdPrefixes, (String)"supportedClientIdPrefixes");
        Intrinsics.checkNotNullParameter((Object)errorDispatchPolicy, (String)"errorDispatchPolicy");
        return new SiopOpenId4VPConfig(issuer, jarConfiguration, responseEncryptionConfiguration, vpConfiguration, clock, jarClockSkew, supportedClientIdPrefixes, errorDispatchPolicy);
    }

    public static /* synthetic */ SiopOpenId4VPConfig copy$default(SiopOpenId4VPConfig siopOpenId4VPConfig, Issuer issuer, JarConfiguration jarConfiguration, ResponseEncryptionConfiguration responseEncryptionConfiguration, VPConfiguration vPConfiguration, Clock clock, Duration duration, List list, ErrorDispatchPolicy errorDispatchPolicy, int n, Object object) {
        if ((n & 1) != 0) {
            issuer = siopOpenId4VPConfig.issuer;
        }
        if ((n & 2) != 0) {
            jarConfiguration = siopOpenId4VPConfig.jarConfiguration;
        }
        if ((n & 4) != 0) {
            responseEncryptionConfiguration = siopOpenId4VPConfig.responseEncryptionConfiguration;
        }
        if ((n & 8) != 0) {
            vPConfiguration = siopOpenId4VPConfig.vpConfiguration;
        }
        if ((n & 0x10) != 0) {
            clock = siopOpenId4VPConfig.clock;
        }
        if ((n & 0x20) != 0) {
            duration = siopOpenId4VPConfig.jarClockSkew;
        }
        if ((n & 0x40) != 0) {
            list = siopOpenId4VPConfig.supportedClientIdPrefixes;
        }
        if ((n & 0x80) != 0) {
            errorDispatchPolicy = siopOpenId4VPConfig.errorDispatchPolicy;
        }
        return siopOpenId4VPConfig.copy(issuer, jarConfiguration, responseEncryptionConfiguration, vPConfiguration, clock, duration, list, errorDispatchPolicy);
    }

    @NotNull
    public String toString() {
        return "SiopOpenId4VPConfig(issuer=" + this.issuer + ", jarConfiguration=" + this.jarConfiguration + ", responseEncryptionConfiguration=" + this.responseEncryptionConfiguration + ", vpConfiguration=" + this.vpConfiguration + ", clock=" + this.clock + ", jarClockSkew=" + this.jarClockSkew + ", supportedClientIdPrefixes=" + this.supportedClientIdPrefixes + ", errorDispatchPolicy=" + this.errorDispatchPolicy + ")";
    }

    public int hashCode() {
        int result = this.issuer == null ? 0 : this.issuer.hashCode();
        result = result * 31 + this.jarConfiguration.hashCode();
        result = result * 31 + this.responseEncryptionConfiguration.hashCode();
        result = result * 31 + this.vpConfiguration.hashCode();
        result = result * 31 + this.clock.hashCode();
        result = result * 31 + this.jarClockSkew.hashCode();
        result = result * 31 + ((Object)this.supportedClientIdPrefixes).hashCode();
        result = result * 31 + this.errorDispatchPolicy.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SiopOpenId4VPConfig)) {
            return false;
        }
        SiopOpenId4VPConfig siopOpenId4VPConfig = (SiopOpenId4VPConfig)other;
        if (!Intrinsics.areEqual((Object)this.issuer, (Object)siopOpenId4VPConfig.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jarConfiguration, (Object)siopOpenId4VPConfig.jarConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseEncryptionConfiguration, (Object)siopOpenId4VPConfig.responseEncryptionConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vpConfiguration, (Object)siopOpenId4VPConfig.vpConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clock, (Object)siopOpenId4VPConfig.clock)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jarClockSkew, (Object)siopOpenId4VPConfig.jarClockSkew)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.supportedClientIdPrefixes, siopOpenId4VPConfig.supportedClientIdPrefixes)) {
            return false;
        }
        return this.errorDispatchPolicy == siopOpenId4VPConfig.errorDispatchPolicy;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig$Companion;", "", "<init>", "()V", "SelfIssued", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "getSelfIssued", "()Lcom/nimbusds/oauth2/sdk/id/Issuer;", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issuer getSelfIssued() {
            return SelfIssued;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

