/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import eu.europa.ec.eudi.openid4vp.PreregisteredClient;
import eu.europa.ec.eudi.openid4vp.internal.DID;
import eu.europa.ec.eudi.openid4vp.internal.request.VerifierAttestationClaims;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u0082\u0001\u0006\b\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "", "Preregistered", "RedirectUri", "DecentralizedIdentifier", "VerifierAttestation", "X509SanDns", "X509Hash", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$Preregistered;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$X509Hash;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$X509SanDns;", "eudi-lib-jvm-siop-openid4vp-kt"})
public interface AuthenticatedClient {

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\tJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "client", "Leu/europa/ec/eudi/openid4vp/internal/DID;", "publicKey", "Ljava/security/PublicKey;", "<init>", "(Ljava/net/URI;Ljava/security/PublicKey;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getClient-VvDq4Xs", "()Ljava/net/URI;", "Ljava/net/URI;", "getPublicKey", "()Ljava/security/PublicKey;", "component1", "component1-VvDq4Xs", "component2", "copy", "copy-DOjJXpM", "(Ljava/net/URI;Ljava/security/PublicKey;)Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$DecentralizedIdentifier;", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class DecentralizedIdentifier
    implements AuthenticatedClient {
        @NotNull
        private final URI client;
        @NotNull
        private final PublicKey publicKey;

        private DecentralizedIdentifier(URI client, PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            this.client = client;
            this.publicKey = publicKey;
        }

        @NotNull
        public final URI getClient-VvDq4Xs() {
            return this.client;
        }

        @NotNull
        public final PublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final URI component1-VvDq4Xs() {
            return this.client;
        }

        @NotNull
        public final PublicKey component2() {
            return this.publicKey;
        }

        @NotNull
        public final DecentralizedIdentifier copy-DOjJXpM(@NotNull URI client, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            return new DecentralizedIdentifier(client, publicKey, null);
        }

        public static /* synthetic */ DecentralizedIdentifier copy-DOjJXpM$default(DecentralizedIdentifier decentralizedIdentifier, URI uRI, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = decentralizedIdentifier.client;
            }
            if ((n & 2) != 0) {
                publicKey = decentralizedIdentifier.publicKey;
            }
            return decentralizedIdentifier.copy-DOjJXpM(uRI, publicKey);
        }

        @NotNull
        public String toString() {
            return "DecentralizedIdentifier(client=" + DID.toString-impl(this.client) + ", publicKey=" + this.publicKey + ")";
        }

        public int hashCode() {
            int result = DID.hashCode-impl(this.client);
            result = result * 31 + this.publicKey.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecentralizedIdentifier)) {
                return false;
            }
            DecentralizedIdentifier decentralizedIdentifier = (DecentralizedIdentifier)other;
            if (!DID.equals-impl0(this.client, decentralizedIdentifier.client)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.publicKey, (Object)decentralizedIdentifier.publicKey);
        }

        public /* synthetic */ DecentralizedIdentifier(URI client, PublicKey publicKey, DefaultConstructorMarker $constructor_marker) {
            this(client, publicKey);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$Preregistered;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "preregisteredClient", "Leu/europa/ec/eudi/openid4vp/PreregisteredClient;", "<init>", "(Leu/europa/ec/eudi/openid4vp/PreregisteredClient;)V", "getPreregisteredClient", "()Leu/europa/ec/eudi/openid4vp/PreregisteredClient;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Preregistered
    implements AuthenticatedClient {
        @NotNull
        private final PreregisteredClient preregisteredClient;

        public Preregistered(@NotNull PreregisteredClient preregisteredClient) {
            Intrinsics.checkNotNullParameter((Object)preregisteredClient, (String)"preregisteredClient");
            this.preregisteredClient = preregisteredClient;
        }

        @NotNull
        public final PreregisteredClient getPreregisteredClient() {
            return this.preregisteredClient;
        }

        @NotNull
        public final PreregisteredClient component1() {
            return this.preregisteredClient;
        }

        @NotNull
        public final Preregistered copy(@NotNull PreregisteredClient preregisteredClient) {
            Intrinsics.checkNotNullParameter((Object)preregisteredClient, (String)"preregisteredClient");
            return new Preregistered(preregisteredClient);
        }

        public static /* synthetic */ Preregistered copy$default(Preregistered preregistered, PreregisteredClient preregisteredClient, int n, Object object) {
            if ((n & 1) != 0) {
                preregisteredClient = preregistered.preregisteredClient;
            }
            return preregistered.copy(preregisteredClient);
        }

        @NotNull
        public String toString() {
            return "Preregistered(preregisteredClient=" + this.preregisteredClient + ")";
        }

        public int hashCode() {
            return this.preregisteredClient.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Preregistered)) {
                return false;
            }
            Preregistered preregistered = (Preregistered)other;
            return Intrinsics.areEqual((Object)this.preregisteredClient, (Object)preregistered.preregisteredClient);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "clientId", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "getClientId", "()Ljava/net/URI;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class RedirectUri
    implements AuthenticatedClient {
        @NotNull
        private final URI clientId;

        public RedirectUri(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
        }

        @NotNull
        public final URI getClientId() {
            return this.clientId;
        }

        @NotNull
        public final URI component1() {
            return this.clientId;
        }

        @NotNull
        public final RedirectUri copy(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return new RedirectUri(clientId);
        }

        public static /* synthetic */ RedirectUri copy$default(RedirectUri redirectUri, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = redirectUri.clientId;
            }
            return redirectUri.copy(uRI);
        }

        @NotNull
        public String toString() {
            return "RedirectUri(clientId=" + this.clientId + ")";
        }

        public int hashCode() {
            return this.clientId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RedirectUri)) {
                return false;
            }
            RedirectUri redirectUri = (RedirectUri)other;
            return Intrinsics.areEqual((Object)this.clientId, (Object)redirectUri.clientId);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "claims", "Leu/europa/ec/eudi/openid4vp/internal/request/VerifierAttestationClaims;", "<init>", "(Ljava/lang/String;Leu/europa/ec/eudi/openid4vp/internal/request/VerifierAttestationClaims;)V", "getClientId", "()Ljava/lang/String;", "getClaims", "()Leu/europa/ec/eudi/openid4vp/internal/request/VerifierAttestationClaims;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class VerifierAttestation
    implements AuthenticatedClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final VerifierAttestationClaims claims;

        public VerifierAttestation(@NotNull String clientId, @NotNull VerifierAttestationClaims claims) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            this.clientId = clientId;
            this.claims = claims;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final VerifierAttestationClaims getClaims() {
            return this.claims;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final VerifierAttestationClaims component2() {
            return this.claims;
        }

        @NotNull
        public final VerifierAttestation copy(@NotNull String clientId, @NotNull VerifierAttestationClaims claims) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            return new VerifierAttestation(clientId, claims);
        }

        public static /* synthetic */ VerifierAttestation copy$default(VerifierAttestation verifierAttestation, String string, VerifierAttestationClaims verifierAttestationClaims, int n, Object object) {
            if ((n & 1) != 0) {
                string = verifierAttestation.clientId;
            }
            if ((n & 2) != 0) {
                verifierAttestationClaims = verifierAttestation.claims;
            }
            return verifierAttestation.copy(string, verifierAttestationClaims);
        }

        @NotNull
        public String toString() {
            return "VerifierAttestation(clientId=" + this.clientId + ", claims=" + this.claims + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.claims.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerifierAttestation)) {
                return false;
            }
            VerifierAttestation verifierAttestation = (VerifierAttestation)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)verifierAttestation.clientId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.claims, (Object)verifierAttestation.claims);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$X509Hash;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "chain", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getClientId", "()Ljava/lang/String;", "getChain", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509Hash
    implements AuthenticatedClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final List<X509Certificate> chain;

        public X509Hash(@NotNull String clientId, @NotNull List<? extends X509Certificate> chain) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter(chain, (String)"chain");
            this.clientId = clientId;
            this.chain = chain;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final List<X509Certificate> getChain() {
            return this.chain;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final List<X509Certificate> component2() {
            return this.chain;
        }

        @NotNull
        public final X509Hash copy(@NotNull String clientId, @NotNull List<? extends X509Certificate> chain) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter(chain, (String)"chain");
            return new X509Hash(clientId, chain);
        }

        public static /* synthetic */ X509Hash copy$default(X509Hash x509Hash, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = x509Hash.clientId;
            }
            if ((n & 2) != 0) {
                list = x509Hash.chain;
            }
            return x509Hash.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "X509Hash(clientId=" + this.clientId + ", chain=" + this.chain + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + ((Object)this.chain).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509Hash)) {
                return false;
            }
            X509Hash x509Hash = (X509Hash)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)x509Hash.clientId)) {
                return false;
            }
            return Intrinsics.areEqual(this.chain, x509Hash.chain);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient$X509SanDns;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "chain", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getClientId", "()Ljava/lang/String;", "getChain", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509SanDns
    implements AuthenticatedClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final List<X509Certificate> chain;

        public X509SanDns(@NotNull String clientId, @NotNull List<? extends X509Certificate> chain) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter(chain, (String)"chain");
            this.clientId = clientId;
            this.chain = chain;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final List<X509Certificate> getChain() {
            return this.chain;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final List<X509Certificate> component2() {
            return this.chain;
        }

        @NotNull
        public final X509SanDns copy(@NotNull String clientId, @NotNull List<? extends X509Certificate> chain) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter(chain, (String)"chain");
            return new X509SanDns(clientId, chain);
        }

        public static /* synthetic */ X509SanDns copy$default(X509SanDns x509SanDns, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = x509SanDns.clientId;
            }
            if ((n & 2) != 0) {
                list = x509SanDns.chain;
            }
            return x509SanDns.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "X509SanDns(clientId=" + this.clientId + ", chain=" + this.chain + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + ((Object)this.chain).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509SanDns)) {
                return false;
            }
            X509SanDns x509SanDns = (X509SanDns)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)x509SanDns.clientId)) {
                return false;
            }
            return Intrinsics.areEqual(this.chain, x509SanDns.chain);
        }
    }
}

