/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import eu.europa.ec.eudi.openid4vp.AuthorizationRequestException;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.Client;
import eu.europa.ec.eudi.openid4vp.Format;
import eu.europa.ec.eudi.openid4vp.IdTokenType;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.ResolutionError;
import eu.europa.ec.eudi.openid4vp.ResolvedRequestObject;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionSpecification;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.Scope;
import eu.europa.ec.eudi.openid4vp.SiopOpenId4VPConfig;
import eu.europa.ec.eudi.openid4vp.TransactionData;
import eu.europa.ec.eudi.openid4vp.TypesKt;
import eu.europa.ec.eudi.openid4vp.VerifierInfo;
import eu.europa.ec.eudi.openid4vp.VpFormatsSupported;
import eu.europa.ec.eudi.openid4vp.dcql.CredentialQuery;
import eu.europa.ec.eudi.openid4vp.dcql.CredentialQueryIds;
import eu.europa.ec.eudi.openid4vp.dcql.DCQL;
import eu.europa.ec.eudi.openid4vp.dcql.QueryId;
import eu.europa.ec.eudi.openid4vp.internal.JsonKt;
import eu.europa.ec.eudi.openid4vp.internal.request.AuthenticatedClient;
import eu.europa.ec.eudi.openid4vp.internal.request.AuthenticatedRequest;
import eu.europa.ec.eudi.openid4vp.internal.request.ClientMetaDataValidator;
import eu.europa.ec.eudi.openid4vp.internal.request.RequestObjectValidatorKt;
import eu.europa.ec.eudi.openid4vp.internal.request.ResponseType;
import eu.europa.ec.eudi.openid4vp.internal.request.TransactionDataTO;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedClientMetaData;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequestObject;
import eu.europa.ec.eudi.openid4vp.internal.request.UriSupportKt;
import eu.europa.ec.eudi.openid4vp.internal.request.ValidatedClientMetaData;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J!\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020!H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0+2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010.\u001a\u00020/2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\rH\u0002J$\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020'2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/RequestObjectValidator;", "", "siopOpenId4VPConfig", "Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "<init>", "(Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;)V", "validateRequestObject", "Leu/europa/ec/eudi/openid4vp/ResolvedRequestObject;", "request", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedRequest;", "requiredDcqlQuery", "Leu/europa/ec/eudi/openid4vp/dcql/DCQL;", "unvalidated", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "scope", "Leu/europa/ec/eudi/openid4vp/Scope;", "walletSupportsVpFormats", "Leu/europa/ec/eudi/openid4vp/VpFormatsSupported;", "requiredDcqlQuery-lCTQYiM", "(Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;Ljava/lang/String;Leu/europa/ec/eudi/openid4vp/VpFormatsSupported;)Leu/europa/ec/eudi/openid4vp/dcql/DCQL;", "lookupKnownDCQLQueries", "lookupKnownDCQLQueries-67VQYRQ", "(Ljava/lang/String;)Leu/europa/ec/eudi/openid4vp/dcql/DCQL;", "optionalTransactionData", "", "Leu/europa/ec/eudi/openid4vp/TransactionData;", "requestObject", "query", "optionalVerifierInfo", "Leu/europa/ec/eudi/openid4vp/VerifierInfo;", "optionalVerifierInfo-ZiCjoKs", "(Leu/europa/ec/eudi/openid4vp/dcql/DCQL;Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;)Ljava/util/List;", "verifierInfo", "Leu/europa/ec/eudi/openid4vp/internal/request/VerifierInfoTO;", "verifierInfo-KPID_KU", "(Leu/europa/ec/eudi/openid4vp/dcql/DCQL;Lkotlinx/serialization/json/JsonArray;)Ljava/util/List;", "optionalIdTokenType", "Leu/europa/ec/eudi/openid4vp/IdTokenType;", "requiredResponseMode", "Leu/europa/ec/eudi/openid4vp/ResponseMode;", "client", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "requiredScope", "Lkotlin/Result;", "requiredScope-IoAF18A", "(Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;)Ljava/lang/Object;", "requiredNonce", "", "requiredResponseType", "Leu/europa/ec/eudi/openid4vp/internal/request/ResponseType;", "optionalClientMetaData", "Leu/europa/ec/eudi/openid4vp/internal/request/ValidatedClientMetaData;", "responseMode", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nRequestObjectValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestObjectValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestObjectValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 5 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n+ 6 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,415:1\n1#2:416\n774#3:417\n865#3,2:418\n1788#3,4:420\n1563#3:424\n1634#3,3:425\n1869#3,2:430\n1563#3:434\n1634#3,3:435\n1563#3:444\n1634#3,3:445\n1740#3,3:459\n32#4,2:428\n32#4,2:442\n32#4,2:448\n32#4,2:450\n32#4,2:452\n40#4,2:454\n32#4,2:456\n32#4,2:462\n32#4,2:464\n40#4,2:466\n32#4,2:468\n40#4,2:470\n21#5,2:432\n23#5,4:438\n335#6:458\n335#6:472\n*S KotlinDebug\n*F\n+ 1 RequestObjectValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestObjectValidator\n*L\n43#1:417\n43#1:418,2\n140#1:420,4\n149#1:424\n149#1:425,3\n158#1:430,2\n171#1:434\n171#1:435,3\n210#1:444\n210#1:445,3\n196#1:459,3\n150#1:428,2\n198#1:442,2\n261#1:448,2\n280#1:450,2\n286#1:452,2\n315#1:454,2\n358#1:456,2\n224#1:462,2\n230#1:464,2\n236#1:466,2\n241#1:468,2\n243#1:470,2\n170#1:432,2\n170#1:438,4\n130#1:458\n343#1:472\n*E\n"})
public final class RequestObjectValidator {
    @NotNull
    private final SiopOpenId4VPConfig siopOpenId4VPConfig;

    public RequestObjectValidator(@NotNull SiopOpenId4VPConfig siopOpenId4VPConfig) {
        Intrinsics.checkNotNullParameter((Object)siopOpenId4VPConfig, (String)"siopOpenId4VPConfig");
        this.siopOpenId4VPConfig = siopOpenId4VPConfig;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResolvedRequestObject validateRequestObject(@NotNull AuthenticatedRequest request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AuthenticatedClient client = request.component1();
        UnvalidatedRequestObject requestObject = request.component2();
        Object scope = this.requiredScope-IoAF18A(requestObject);
        Scope.Companion $this$validateRequestObject_u24lambda_u241 = Scope.Companion;
        boolean bl = false;
        Scope scope2 = (Scope)(Result.isFailure-impl((Object)scope) ? null : scope);
        Object object = scope2 != null ? scope2.unbox-impl() : null;
        if (object != null && (object = Scope.items-impl((String)object)) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = ((Scope)element$iv$iv).unbox-impl();
                boolean bl2 = false;
                if (!(!Scope.equals-impl0(it, $this$validateRequestObject_u24lambda_u241.getOpenId-XA_HY7U()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string = $this$validateRequestObject_u24lambda_u241.mergeOrNull-UWI4fOY((List)destination$iv$iv);
        } else {
            string = null;
        }
        Scope scope3 = string != null ? Scope.box-impl(string) : null;
        String nonOpenIdScope = scope3 != null ? scope3.unbox-impl() : null;
        String state = requestObject.getState();
        String nonce = this.requiredNonce(requestObject);
        ResponseType responseType = this.requiredResponseType(requestObject);
        ResponseMode responseMode = this.requiredResponseMode(client, requestObject);
        List<IdTokenType> idTokenType = this.optionalIdTokenType(requestObject);
        return switch (WhenMappings.$EnumSwitchMapping$0[responseType.ordinal()]) {
            case 1 -> {
                Scope v4 = (Scope)(Result.isFailure-impl((Object)scope) ? null : scope);
                String v5 = v4 != null ? v4.unbox-impl() : null;
                boolean v6 = v5 != null ? Scope.contains-67VQYRQ(v5, Scope.Companion.getOpenId-XA_HY7U()) : false;
                if (v6) {
                    yield RequestObjectValidator.validateRequestObject$idAndVpToken(this, requestObject, nonOpenIdScope, responseMode, client, state, nonce, idTokenType, scope);
                }
                yield RequestObjectValidator.validateRequestObject$vpToken(this, requestObject, nonOpenIdScope, responseMode, client, state, nonce);
            }
            case 2 -> RequestObjectValidator.validateRequestObject$idToken(this, responseMode, requestObject, client, state, nonce, idTokenType, scope);
            case 3 -> RequestObjectValidator.validateRequestObject$vpToken(this, requestObject, nonOpenIdScope, responseMode, client, state, nonce);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final DCQL requiredDcqlQuery-lCTQYiM(UnvalidatedRequestObject unvalidated, String scope, VpFormatsSupported walletSupportsVpFormats) {
        void $this$mapTo$iv$iv;
        DCQL dCQL;
        Object element$iv2;
        int n;
        Map map = (Map)unvalidated.getDcqlQuery();
        boolean hasDcqlQuery = !(map == null || map.isEmpty());
        boolean hasScope = scope != null;
        Object[] objectArray = new Boolean[]{hasDcqlQuery, hasScope};
        Iterable $this$count$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv2 : $this$count$iv) {
                boolean it = (Boolean)element$iv2;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int querySourceCount = n;
        if (querySourceCount > 1) {
            throw AuthorizationRequestResolverKt.asException(RequestValidationError.MultipleQuerySources.INSTANCE);
        }
        if (hasDcqlQuery) {
            dCQL = RequestObjectValidator.requiredDcqlQuery_lCTQYiM$requiredDcqlQuery(unvalidated);
        } else if (hasScope) {
            dCQL = RequestObjectValidator.requiredDcqlQuery_lCTQYiM$requiredScope(scope, this);
        } else {
            throw AuthorizationRequestResolverKt.asException(RequestValidationError.MissingQuerySource.INSTANCE);
        }
        DCQL query = dCQL;
        Iterable $this$map$iv = query.getCredentials-Mvz7B_Q();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CredentialQuery credentialQuery = (CredentialQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Format.box-impl(it.getFormat-mS_2FiM()));
        }
        Set queryFormats = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean value$iv = TypesKt.containsAll(walletSupportsVpFormats, queryFormats);
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.UnsupportedQueryFormats.INSTANCE);
        }
        return query;
    }

    private final DCQL lookupKnownDCQLQueries-67VQYRQ(String scope) {
        Iterable $this$forEach$iv = Scope.items-impl(scope);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = ((Scope)element$iv).unbox-impl();
            boolean bl = false;
            DCQL dCQL = this.siopOpenId4VPConfig.getVpConfiguration().getKnownDCQLQueriesPerScope().get(item);
            if (dCQL == null) continue;
            DCQL it = dCQL;
            boolean bl2 = false;
            return it;
        }
        throw AuthorizationRequestResolverKt.asException(new ResolutionError.UnknownScope(scope, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TransactionData> optionalTransactionData(UnvalidatedRequestObject requestObject, DCQL query) {
        List list;
        JsonArray jsonArray = requestObject.getTransactionData-7__Ctis();
        if (jsonArray != null) {
            Object object;
            JsonArray unresolvedTransactionData = jsonArray;
            boolean bl = false;
            boolean $i$f$runCatchingCancellable = false;
            try {
                void $this$mapTo$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv = TransactionDataTO.getValues-impl(unresolvedTransactionData);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void unresolved;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Object object2 = TransactionData.Companion.parse-gIAlu-s((String)unresolved, query);
                    ResultKt.throwOnFailure((Object)object2);
                    TransactionData transactionData = (TransactionData)object2;
                    RequestObjectValidatorKt.access$ensureSupported(transactionData, this.siopOpenId4VPConfig.getVpConfiguration().getSupportedTransactionDataTypes());
                    collection.add(transactionData);
                }
                object = Result.constructor-impl((Object)((List)destination$iv$iv));
            }
            catch (CancellationException ce$iv) {
                throw ce$iv;
            }
            catch (Exception e$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
            }
            Object object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable error = throwable;
                boolean bl4 = false;
                throw AuthorizationRequestResolverKt.asException(new ResolutionError.InvalidTransactionData(error));
            }
            list = (List)object3;
        } else {
            list = null;
        }
        return list;
    }

    private final List<? extends VerifierInfo.Attestation> optionalVerifierInfo-ZiCjoKs(DCQL query, UnvalidatedRequestObject unvalidated) {
        List<? extends VerifierInfo.Attestation> list;
        JsonArray jsonArray = unvalidated.getVerifierInfo-XRGlV_w();
        if (jsonArray != null) {
            JsonArray it = jsonArray;
            boolean bl = false;
            list = this.verifierInfo-KPID_KU(query, it);
        } else {
            list = null;
        }
        return list;
    }

    private final List<? extends VerifierInfo.Attestation> verifierInfo-KPID_KU(DCQL query, JsonArray unvalidated) {
        Object object = VerifierInfo.Companion.fromJson-IoAF18A(unvalidated);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            throw RequestObjectValidator.verifierInfo_KPID_KU$invalid("Failed to deserialize verifier_info. Cause: " + error.getMessage());
        }
        List verifierInfo = ((VerifierInfo)object).unbox-impl();
        boolean value$iv = RequestObjectValidator.verifierInfo_KPID_KU$validQueryIds(verifierInfo, query);
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            String error = "There are verifier attestations that use credential_id(s) not present in DCQL";
            throw (Throwable)RequestObjectValidator.verifierInfo_KPID_KU$invalid(error);
        }
        return verifierInfo;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<IdTokenType> optionalIdTokenType(UnvalidatedRequestObject unvalidated) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        List list2;
        block8: {
            block7: {
                String string = unvalidated.getIdTokenType();
                if (string == null) break block7;
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (string2 == null) break block7;
                String[] stringArray = new String[]{" "};
                list2 = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (list2 != null) break block8;
            }
            list = CollectionsKt.emptyList();
            return list;
        }
        Iterable iterable = list2;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (true) {
            IdTokenType idTokenType;
            void type;
            if (!iterator.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var15_15 = type;
            if (Intrinsics.areEqual((Object)var15_15, (Object)"subject_signed_id_token")) {
                idTokenType = IdTokenType.SubjectSigned;
            } else {
                if (!Intrinsics.areEqual((Object)var15_15, (Object)"attester_signed_id_token")) throw new IllegalStateException(("Invalid id_token_type " + (String)type).toString());
                idTokenType = IdTokenType.AttesterSigned;
            }
            collection.add(idTokenType);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ResponseMode requiredResponseMode(AuthenticatedClient client, UnvalidatedRequestObject unvalidated) {
        var4_3 = unvalidated.getResponseMode();
        if (var4_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var4_3.hashCode()) {
            case -1650269616: {
                if (var4_3.equals("fragment")) {
                    tmp = 1;
                }
                break;
            }
            case 1910489129: {
                if (var4_3.equals("fragment.jwt")) {
                    tmp = 2;
                }
                break;
            }
            case 107944136: {
                if (var4_3.equals("query")) {
                    tmp = 3;
                }
                break;
            }
            case 1967634959: {
                if (var4_3.equals("direct_post.jwt")) {
                    tmp = 4;
                }
                break;
            }
            case -1641038026: {
                if (var4_3.equals("direct_post")) {
                    tmp = 5;
                }
                break;
            }
            case -1808008543: {
                if (var4_3.equals("query.jwt")) {
                    tmp = 6;
                }
                break;
            }
        }
        switch (tmp) {
            case 5: {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredResponseUriAndNotProvidedRedirectUri(unvalidated);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$1 = false;
                v0 = new ResponseMode.DirectPost((URL)it /* !! */ );
                break;
            }
            case 4: {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredResponseUriAndNotProvidedRedirectUri(unvalidated);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$2 = false;
                v0 = new ResponseMode.DirectPostJwt((URL)it /* !! */ );
                break;
            }
            case 3: {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri(unvalidated, client);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$3 = false;
                v0 = new ResponseMode.Query(it /* !! */ );
                break;
            }
            case 6: {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri(unvalidated, client);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$4 = false;
                v0 = new ResponseMode.QueryJwt(it /* !! */ );
                break;
            }
            case 1: lbl-1000:
            // 2 sources

            {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri(unvalidated, client);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$5 = false;
                v0 = new ResponseMode.Fragment(it /* !! */ );
                break;
            }
            case 2: {
                it /* !! */  = RequestObjectValidator.requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri(unvalidated, client);
                $i$a$-let-RequestObjectValidator$requiredResponseMode$responseMode$6 = false;
                v0 = new ResponseMode.FragmentJwt(it /* !! */ );
                break;
            }
            default: {
                throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseMode(unvalidated.getResponseMode()));
            }
        }
        responseMode = v0;
        uri = RequestObjectValidatorKt.access$uri(responseMode);
        var5_11 = client;
        if (!(var5_11 instanceof AuthenticatedClient.Preregistered)) {
            if (var5_11 instanceof AuthenticatedClient.RedirectUri) {
                value$iv = Intrinsics.areEqual((Object)((AuthenticatedClient.RedirectUri)client).getClientId(), (Object)uri);
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-RequestObjectValidator$requiredResponseMode$1 = false;
                    throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseMode(responseMode + " doesn't match " + ((AuthenticatedClient.RedirectUri)client).getClientId()));
                }
            } else if (!(var5_11 instanceof AuthenticatedClient.DecentralizedIdentifier)) {
                if (var5_11 instanceof AuthenticatedClient.VerifierAttestation) {
                    $i$f$ensure = responseMode;
                    if ($i$f$ensure instanceof ResponseMode.Query || $i$f$ensure instanceof ResponseMode.QueryJwt || $i$f$ensure instanceof ResponseMode.Fragment || $i$f$ensure instanceof ResponseMode.FragmentJwt) {
                        v1 = ((AuthenticatedClient.VerifierAttestation)client).getClaims().getRedirectUris();
                    } else if ($i$f$ensure instanceof ResponseMode.DirectPost || $i$f$ensure instanceof ResponseMode.DirectPostJwt) {
                        v1 = ((AuthenticatedClient.VerifierAttestation)client).getClaims().getResponseUris();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    allowedUris = v1;
                    $i$f$ensure = allowedUris;
                    if (!($i$f$ensure == null || $i$f$ensure.isEmpty() != false)) {
                        value$iv = allowedUris.contains(uri.toString());
                        $i$f$ensure = false;
                        if (!value$iv) {
                            $i$a$-ensure-RequestObjectValidator$requiredResponseMode$2 = false;
                            throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseMode(responseMode + " use a URI that is not included in attested URIs " + allowedUris));
                        }
                    }
                } else if (var5_11 instanceof AuthenticatedClient.X509SanDns) {
                    value$iv = Intrinsics.areEqual((Object)((AuthenticatedClient.X509SanDns)client).getClientId(), (Object)uri.getHost());
                    $i$f$ensure = false;
                    if (!value$iv) {
                        $i$a$-ensure-RequestObjectValidator$requiredResponseMode$3 = false;
                        throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseMode(responseMode + " host doesn't match " + ((AuthenticatedClient.X509SanDns)client).getClientId()));
                    }
                } else if (!(var5_11 instanceof AuthenticatedClient.X509Hash)) {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return responseMode;
    }

    private final Object requiredScope-IoAF18A(UnvalidatedRequestObject unvalidated) {
        String scope;
        String string = unvalidated.getScope();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = Scope.Companion.make-UWI4fOY(it);
            Scope scope2 = string2 != null ? Scope.box-impl(string2) : null;
            v3 = scope2 != null ? scope2.unbox-impl() : null;
        } else {
            v3 = scope = null;
        }
        return scope != null ? Result.constructor-impl((Object)Scope.box-impl(scope)) : AuthorizationRequestResolverKt.asFailure(RequestValidationError.MissingScope.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final String requiredNonce(UnvalidatedRequestObject unvalidated) {
        void var2_2;
        String value$iv = unvalidated.getNonce();
        boolean $i$f$ensureNotNull = false;
        if (value$iv == null) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.MissingNonce.INSTANCE);
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ResponseType requiredResponseType(UnvalidatedRequestObject unvalidated) {
        ResponseType responseType;
        String rt;
        block9: {
            block10: {
                String string = unvalidated.getResponseType();
                String string2 = rt = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                if (string2 == null) throw AuthorizationRequestResolverKt.asException(RequestValidationError.MissingResponseType.INSTANCE);
                switch (string2.hashCode()) {
                    case -1355302860: {
                        if (rt.equals("vp_token")) break;
                        throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseType(rt));
                    }
                    case -302143019: {
                        if (!rt.equals("id_token")) {
                            throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseType(rt));
                        }
                        break block9;
                    }
                    case 1567476801: {
                        if (!rt.equals("vp_token id_token")) {
                            throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseType(rt));
                        }
                        break block10;
                    }
                    case 1932602911: {
                        if (!rt.equals("id_token vp_token")) {
                            throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseType(rt));
                        }
                        break block10;
                    }
                }
                responseType = ResponseType.VpToken;
                return responseType;
            }
            responseType = ResponseType.VpAndIdToken;
            return responseType;
        }
        responseType = ResponseType.IdToken;
        return responseType;
        throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedResponseType(rt));
    }

    private final ValidatedClientMetaData optionalClientMetaData(ResponseMode responseMode, DCQL query, UnvalidatedRequestObject unvalidated) {
        ValidatedClientMetaData validatedClientMetaData;
        Map map = (Map)unvalidated.getClientMetaData();
        boolean hasCMD = !(map == null || map.isEmpty());
        if (hasCMD) {
            UnvalidatedClientMetaData it = RequestObjectValidator.optionalClientMetaData$requiredClientMetaData(unvalidated);
            boolean bl = false;
            validatedClientMetaData = ClientMetaDataValidator.INSTANCE.validateClientMetaData(it, responseMode, query, this.siopOpenId4VPConfig.getResponseEncryptionConfiguration(), this.siopOpenId4VPConfig.getVpConfiguration().getVpFormatsSupported());
        } else {
            boolean value$iv = !TypesKt.requiresEncryption(responseMode);
            boolean $i$f$ensure = false;
            if (!value$iv) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("Missing client metadata"));
            }
            validatedClientMetaData = null;
        }
        return validatedClientMetaData;
    }

    private static final ResolvedRequestObject.SiopAuthentication validateRequestObject$idToken(RequestObjectValidator this$0, ResponseMode responseMode, UnvalidatedRequestObject requestObject, AuthenticatedClient client, String state, String nonce, List<? extends IdTokenType> idTokenType, Object scope) {
        ValidatedClientMetaData clientMetaData = this$0.optionalClientMetaData(responseMode, null, requestObject);
        Client client2 = RequestObjectValidatorKt.access$toClient(client);
        ValidatedClientMetaData validatedClientMetaData = clientMetaData;
        ResponseEncryptionSpecification responseEncryptionSpecification = validatedClientMetaData != null ? validatedClientMetaData.getResponseEncryptionSpecification() : null;
        ValidatedClientMetaData validatedClientMetaData2 = clientMetaData;
        List list = validatedClientMetaData2 != null ? validatedClientMetaData2.getSubjectSyntaxTypesSupported() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Object object = scope;
        ResultKt.throwOnFailure((Object)object);
        return new ResolvedRequestObject.SiopAuthentication(client2, responseMode, state, nonce, responseEncryptionSpecification, idTokenType, list, ((Scope)object).unbox-impl(), null);
    }

    private static final ResolvedRequestObject.OpenId4VPAuthorization validateRequestObject$vpToken(RequestObjectValidator this$0, UnvalidatedRequestObject requestObject, String nonOpenIdScope, ResponseMode responseMode, AuthenticatedClient client, String state, String nonce) {
        DCQL query = this$0.requiredDcqlQuery-lCTQYiM(requestObject, nonOpenIdScope, this$0.siopOpenId4VPConfig.getVpConfiguration().getVpFormatsSupported());
        List<TransactionData> transactionData = this$0.optionalTransactionData(requestObject, query);
        List<? extends VerifierInfo.Attestation> verifierInfo = this$0.optionalVerifierInfo-ZiCjoKs(query, requestObject);
        ValidatedClientMetaData clientMetaData = this$0.optionalClientMetaData(responseMode, query, requestObject);
        ValidatedClientMetaData validatedClientMetaData = clientMetaData;
        ValidatedClientMetaData validatedClientMetaData2 = clientMetaData;
        return new ResolvedRequestObject.OpenId4VPAuthorization(RequestObjectValidatorKt.access$toClient(client), responseMode, state, nonce, validatedClientMetaData != null ? validatedClientMetaData.getResponseEncryptionSpecification() : null, validatedClientMetaData2 != null ? validatedClientMetaData2.getVpFormatsSupported() : null, query, transactionData, verifierInfo, null);
    }

    private static final ResolvedRequestObject.SiopOpenId4VPAuthentication validateRequestObject$idAndVpToken(RequestObjectValidator this$0, UnvalidatedRequestObject requestObject, String nonOpenIdScope, ResponseMode responseMode, AuthenticatedClient client, String state, String nonce, List<? extends IdTokenType> idTokenType, Object scope) {
        DCQL query = this$0.requiredDcqlQuery-lCTQYiM(requestObject, nonOpenIdScope, this$0.siopOpenId4VPConfig.getVpConfiguration().getVpFormatsSupported());
        List<TransactionData> transactionData = this$0.optionalTransactionData(requestObject, query);
        List<? extends VerifierInfo.Attestation> verifierInfo = this$0.optionalVerifierInfo-ZiCjoKs(query, requestObject);
        ValidatedClientMetaData clientMetaData = this$0.optionalClientMetaData(responseMode, query, requestObject);
        Client client2 = RequestObjectValidatorKt.access$toClient(client);
        ValidatedClientMetaData validatedClientMetaData = clientMetaData;
        ResponseEncryptionSpecification responseEncryptionSpecification = validatedClientMetaData != null ? validatedClientMetaData.getResponseEncryptionSpecification() : null;
        ValidatedClientMetaData validatedClientMetaData2 = clientMetaData;
        VpFormatsSupported vpFormatsSupported = validatedClientMetaData2 != null ? validatedClientMetaData2.getVpFormatsSupported() : null;
        ValidatedClientMetaData validatedClientMetaData3 = clientMetaData;
        List list = validatedClientMetaData3 != null ? validatedClientMetaData3.getSubjectSyntaxTypesSupported() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Object object = scope;
        ResultKt.throwOnFailure((Object)object);
        return new ResolvedRequestObject.SiopOpenId4VPAuthentication(client2, responseMode, state, nonce, responseEncryptionSpecification, vpFormatsSupported, idTokenType, list, ((Scope)object).unbox-impl(), query, transactionData, verifierInfo, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final DCQL requiredDcqlQuery_lCTQYiM$requiredDcqlQuery(UnvalidatedRequestObject $unvalidated) {
        Object object;
        try {
            void $this$decodeFromJsonElement$iv;
            if ($unvalidated.getDcqlQuery() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            object = JsonKt.getJsonSupport();
            JsonElement json$iv = (JsonElement)$unvalidated.getDcqlQuery();
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            object = (DCQL)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)DCQL.Companion.serializer(), json$iv);
        }
        catch (SerializationException t) {
            throw AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidDigitalCredentialsQuery(t));
        }
        return object;
    }

    private static final DCQL requiredDcqlQuery_lCTQYiM$requiredScope(String $scope, RequestObjectValidator this$0) {
        String string = $scope;
        if ((string != null ? Scope.box-impl(string) : null) == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        return this$0.lookupKnownDCQLQueries-67VQYRQ($scope);
    }

    private static final AuthorizationRequestException verifierInfo_KPID_KU$invalid(String reason) {
        return AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidVerifierInfo(reason));
    }

    private static final boolean verifierInfo_KPID_KU$validQueryIds(List<? extends VerifierInfo.Attestation> $this$verifierInfo_KPID_KU_u24validQueryIds, DCQL $query) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $this$verifierInfo_KPID_KU_u24validQueryIds;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VerifierInfo.Attestation attestation = (VerifierInfo.Attestation)element$iv;
                    boolean bl2 = false;
                    List<? extends QueryId> list = attestation.getCredentialIds-QGPbjIs();
                    Collection collection = list != null ? CredentialQueryIds.unknownIds-zsiAVq0(list, $query.getCredentials-Mvz7B_Q()) : null;
                    if (collection == null || collection.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Throwable requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri$lambda$17(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidRedirectUri.INSTANCE);
    }

    private static final URI requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri(UnvalidatedRequestObject $unvalidated, AuthenticatedClient $client) {
        URI uRI;
        URI redirectUri;
        boolean value$iv = $unvalidated.getResponseUri() == null;
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.ResponseUriMustNotBeProvided.INSTANCE);
        }
        String string = $unvalidated.getRedirectUri();
        if (string != null) {
            Object object = UriSupportKt.asURI(string, (Function1<? super Throwable, ? extends Throwable>)((Function1)RequestObjectValidator::requiredResponseMode$requiredRedirectUriAndNotProvidedResponseUri$lambda$17));
            ResultKt.throwOnFailure((Object)object);
            v1 = (URI)object;
        } else {
            v1 = redirectUri = null;
        }
        if ($client instanceof AuthenticatedClient.RedirectUri) {
            boolean value$iv2 = redirectUri == null || Intrinsics.areEqual((Object)((AuthenticatedClient.RedirectUri)$client).getClientId(), (Object)redirectUri);
            boolean $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidRedirectUri.INSTANCE);
            }
            uRI = ((AuthenticatedClient.RedirectUri)$client).getClientId();
        } else {
            boolean $i$f$ensureNotNull = false;
            if (redirectUri == null) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.MissingRedirectUri.INSTANCE);
            }
            uRI = redirectUri;
        }
        return uRI;
    }

    private static final Throwable requiredResponseMode$requiredResponseUriAndNotProvidedRedirectUri$lambda$22(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidResponseUri.INSTANCE);
    }

    private static final URL requiredResponseMode$requiredResponseUriAndNotProvidedRedirectUri(UnvalidatedRequestObject $unvalidated) {
        boolean value$iv = $unvalidated.getRedirectUri() == null;
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.RedirectUriMustNotBeProvided.INSTANCE);
        }
        String uri = $unvalidated.getResponseUri();
        boolean $i$f$ensureNotNull = false;
        if (uri == null) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.MissingResponseUri.INSTANCE);
        }
        Object object = UriSupportKt.asURL(uri, (Function1<? super Throwable, ? extends Throwable>)((Function1)RequestObjectValidator::requiredResponseMode$requiredResponseUriAndNotProvidedRedirectUri$lambda$22));
        ResultKt.throwOnFailure((Object)object);
        return (URL)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final UnvalidatedClientMetaData optionalClientMetaData$requiredClientMetaData(UnvalidatedRequestObject $unvalidated) {
        void $this$decodeFromJsonElement$iv;
        if ($unvalidated.getClientMetaData() == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Json json = JsonKt.getJsonSupport();
        JsonElement json$iv = (JsonElement)$unvalidated.getClientMetaData();
        boolean $i$f$decodeFromJsonElement = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        return (UnvalidatedClientMetaData)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)UnvalidatedClientMetaData.Companion.serializer(), json$iv);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.VpAndIdToken.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.IdToken.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.VpToken.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

