/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.util.DateUtils;
import java.time.Clock;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/TimeChecks;", "Lcom/nimbusds/jwt/proc/JWTClaimsSetVerifier;", "Lcom/nimbusds/jose/proc/SecurityContext;", "clock", "Ljava/time/Clock;", "skew", "Lkotlin/time/Duration;", "<init>", "(Ljava/time/Clock;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "verify", "", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "context", "eudi-lib-jvm-siop-openid4vp-kt"})
final class TimeChecks
implements JWTClaimsSetVerifier<SecurityContext> {
    @NotNull
    private final Clock clock;
    private final long skew;

    private TimeChecks(Clock clock, long skew) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.skew = skew;
    }

    public void verify(@NotNull JWTClaimsSet claimsSet, @Nullable SecurityContext context) throws BadJWTException {
        Intrinsics.checkNotNullParameter((Object)claimsSet, (String)"claimsSet");
        Date now = Date.from(this.clock.instant());
        long skewInSeconds = Duration.getInWholeSeconds-impl((long)this.skew);
        Date exp = claimsSet.getExpirationTime();
        if (exp != null && !DateUtils.isAfter((Date)exp, (Date)now, (long)skewInSeconds)) {
            throw new BadJWTException("Expired JWT");
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (nbf != null && !DateUtils.isBefore((Date)nbf, (Date)now, (long)skewInSeconds)) {
            throw new BadJWTException("JWT before use time");
        }
    }

    public /* synthetic */ TimeChecks(Clock clock, long skew, DefaultConstructorMarker $constructor_marker) {
        this(clock, skew);
    }
}

