/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import eu.europa.ec.eudi.openid4vp.AuthorizationRequestError;
import eu.europa.ec.eudi.openid4vp.EncryptionParameters;
import eu.europa.ec.eudi.openid4vp.ErrorDispatchDetails;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.VerifierId;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponse;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponsePayload;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"responseWith", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponse;", "Leu/europa/ec/eudi/openid4vp/AuthorizationRequestError;", "di", "Leu/europa/ec/eudi/openid4vp/ErrorDispatchDetails;", "encryptionParameters", "Leu/europa/ec/eudi/openid4vp/EncryptionParameters;", "data", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponsePayload$InvalidRequest;", "eudi-lib-jvm-siop-openid4vp-kt"})
public final class ErrorResponseKt {
    @NotNull
    public static final AuthorizationResponse responseWith(@NotNull AuthorizationRequestError $this$responseWith, @NotNull ErrorDispatchDetails di, @Nullable EncryptionParameters encryptionParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$responseWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        String string = di.getState();
        String string2 = di.getNonce();
        VerifierId verifierId = di.getClientId();
        AuthorizationResponsePayload.InvalidRequest payload = new AuthorizationResponsePayload.InvalidRequest($this$responseWith, string2, string, verifierId, encryptionParameters);
        return ErrorResponseKt.responseWith(di, payload);
    }

    private static final AuthorizationResponse responseWith(ErrorDispatchDetails di, AuthorizationResponsePayload.InvalidRequest data) {
        AuthorizationResponse authorizationResponse;
        ResponseMode mode = di.getResponseMode();
        if (mode instanceof ResponseMode.DirectPost) {
            authorizationResponse = new AuthorizationResponse.DirectPost(((ResponseMode.DirectPost)mode).getResponseURI(), data);
        } else if (mode instanceof ResponseMode.DirectPostJwt) {
            authorizationResponse = new AuthorizationResponse.DirectPostJwt(((ResponseMode.DirectPostJwt)mode).getResponseURI(), data, di.getResponseEncryptionSpecification());
        } else if (mode instanceof ResponseMode.Fragment) {
            authorizationResponse = new AuthorizationResponse.Fragment(((ResponseMode.Fragment)mode).getRedirectUri(), data);
        } else if (mode instanceof ResponseMode.FragmentJwt) {
            authorizationResponse = new AuthorizationResponse.FragmentJwt(((ResponseMode.FragmentJwt)mode).getRedirectUri(), data, di.getResponseEncryptionSpecification());
        } else if (mode instanceof ResponseMode.Query) {
            authorizationResponse = new AuthorizationResponse.Query(((ResponseMode.Query)mode).getRedirectUri(), data);
        } else if (mode instanceof ResponseMode.QueryJwt) {
            authorizationResponse = new AuthorizationResponse.QueryJwt(((ResponseMode.QueryJwt)mode).getRedirectUri(), data, di.getResponseEncryptionSpecification());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return authorizationResponse;
    }
}

