/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.server.signing.rest.client;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.server.signing.dto.RemoteKeyEntry;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.util.List;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface RestSignatureTokenConnection
extends Serializable {
    @GET
    @Path(value="keys")
    public List<RemoteKeyEntry> getKeys();

    @GET
    @Path(value="key/{alias}")
    public RemoteKeyEntry getKey(@PathParam(value="alias") String var1);

    @POST
    @Path(value="sign/{alias}/{algo}")
    public SignatureValueDTO sign(ToBeSignedDTO var1, @PathParam(value="algo") DigestAlgorithm var2, @PathParam(value="alias") String var3);

    @POST
    @Path(value="sign/{alias}/{digest-algo}/{mask}")
    public SignatureValueDTO sign(ToBeSignedDTO var1, @PathParam(value="digest-algo") DigestAlgorithm var2, @PathParam(value="mask") MaskGenerationFunction var3, @PathParam(value="alias") String var4);

    @POST
    @Path(value="sign-with-signature-algo/{alias}/{signature-algo}")
    public SignatureValueDTO sign(ToBeSignedDTO var1, @PathParam(value="signature-algo") SignatureAlgorithm var2, @PathParam(value="alias") String var3);

    @POST
    @Path(value="sign-digest/{alias}")
    public SignatureValueDTO signDigest(DigestDTO var1, @PathParam(value="alias") String var2);

    @POST
    @Path(value="sign-digest/{alias}/{mask}")
    public SignatureValueDTO signDigest(DigestDTO var1, @PathParam(value="mask") MaskGenerationFunction var2, @PathParam(value="alias") String var3);

    @POST
    @Path(value="sign-digest-with-signature-algo/{alias}/{signature-algo}")
    public SignatureValueDTO signDigest(DigestDTO var1, @PathParam(value="signature-algo") SignatureAlgorithm var2, @PathParam(value="alias") String var3);
}

