/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.extension3;

import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NjordRepositoryConnector
implements RepositoryConnector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArtifactStore artifactStore;
    private final RemoteRepository remoteRepository;
    private final RepositoryConnector delegate;

    public NjordRepositoryConnector(ArtifactStore artifactStore, RemoteRepository remoteRepository, RepositoryConnector delegate) {
        this.artifactStore = Objects.requireNonNull(artifactStore);
        this.remoteRepository = Objects.requireNonNull(remoteRepository);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        this.delegate.get(artifactDownloads, metadataDownloads);
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        block11: {
            try (ArtifactStore.Operation putOperation = this.artifactStore.put(artifactUploads != null ? (Collection)artifactUploads.stream().map(u -> u.getArtifact().setFile(u.getFile())).collect(Collectors.toList()) : Collections.emptyList(), metadataUploads != null ? (Collection)metadataUploads.stream().map(u -> u.getMetadata().setFile(u.getFile())).collect(Collectors.toList()) : Collections.emptyList());){
                this.delegate.put(artifactUploads, metadataUploads);
                if (artifactUploads != null && artifactUploads.stream().anyMatch(u -> u.getException() != null)) {
                    putOperation.cancel();
                    throw new IOException("PUT failed");
                }
                if (metadataUploads != null && metadataUploads.stream().anyMatch(u -> u.getException() != null)) {
                    putOperation.cancel();
                    throw new IOException("PUT failed");
                }
            }
            catch (IOException e) {
                if (artifactUploads != null) {
                    artifactUploads.stream().filter(u -> u.getException() == null).forEach(u -> u.setException(new ArtifactTransferException(u.getArtifact(), this.remoteRepository, (Throwable)e)));
                }
                if (metadataUploads == null) break block11;
                metadataUploads.stream().filter(u -> u.getException() == null).forEach(u -> u.setException(new MetadataTransferException(u.getMetadata(), this.remoteRepository, (Throwable)e)));
            }
        }
    }

    public void close() {
        try {
            this.artifactStore.close();
        }
        catch (IOException e) {
            this.logger.warn("Failed to close artifactStore", (Throwable)e);
        }
        finally {
            this.delegate.close();
        }
    }
}

