package fr.enedis.chutney.scenario.api.raw.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GwtScenarioDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGwtScenarioDto.builder()}.
 */
@Generated(from = "GwtScenarioDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGwtScenarioDto implements GwtScenarioDto {
  private final List<GwtStepDto> givens;
  private final GwtStepDto when;
  private final List<GwtStepDto> thens;

  private ImmutableGwtScenarioDto(
      List<GwtStepDto> givens,
      GwtStepDto when,
      List<GwtStepDto> thens) {
    this.givens = givens;
    this.when = when;
    this.thens = thens;
  }

  /**
   * @return The value of the {@code givens} attribute
   */
  @JsonProperty(value = "givens")
  @Override
  public List<GwtStepDto> givens() {
    return givens;
  }

  /**
   * @return The value of the {@code when} attribute
   */
  @JsonProperty(value = "when", required = true)
  @Override
  public GwtStepDto when() {
    return when;
  }

  /**
   * @return The value of the {@code thens} attribute
   */
  @JsonProperty(value = "thens")
  @Override
  public List<GwtStepDto> thens() {
    return thens;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtScenarioDto#givens() givens}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtScenarioDto withGivens(GwtStepDto... elements) {
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGwtScenarioDto(newValue, this.when, this.thens);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtScenarioDto#givens() givens}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of givens elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableGwtScenarioDto withGivens(Iterable<? extends GwtStepDto> elements) {
    if (this.givens == elements) return this;
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGwtScenarioDto(newValue, this.when, this.thens);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GwtScenarioDto#when() when} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for when
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableGwtScenarioDto withWhen(GwtStepDto value) {
    if (this.when == value) return this;
    GwtStepDto newValue = Objects.requireNonNull(value, "when");
    return new ImmutableGwtScenarioDto(this.givens, newValue, this.thens);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtScenarioDto#thens() thens}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtScenarioDto withThens(GwtStepDto... elements) {
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGwtScenarioDto(this.givens, this.when, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtScenarioDto#thens() thens}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thens elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableGwtScenarioDto withThens(Iterable<? extends GwtStepDto> elements) {
    if (this.thens == elements) return this;
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGwtScenarioDto(this.givens, this.when, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGwtScenarioDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGwtScenarioDto
        && equalsByValue((ImmutableGwtScenarioDto) another);
  }

  private boolean equalsByValue(ImmutableGwtScenarioDto another) {
    return givens.equals(another.givens)
        && when.equals(another.when)
        && thens.equals(another.thens);
  }

  /**
   * Computes a hash code from attributes: {@code givens}, {@code when}, {@code thens}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + givens.hashCode();
    h += (h << 5) + when.hashCode();
    h += (h << 5) + thens.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GwtScenarioDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GwtScenarioDto{"
        + "givens=" + givens
        + ", when=" + when
        + ", thens=" + thens
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GwtScenarioDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements GwtScenarioDto {
    @JsonIgnore @Nullable List<GwtStepDto> _givens = Collections.emptyList();
    @JsonIgnore @Nullable GwtStepDto _when;
    @JsonIgnore @Nullable List<GwtStepDto> _thens = Collections.emptyList();

    @JsonProperty(value = "givens")
    public void setGivens(List<GwtStepDto> givens) {
      this._givens = givens;
    }

    @JsonProperty(value = "when", required = true)
    public void setWhen(GwtStepDto when) {
      this._when = when;
    }

    @JsonProperty(value = "thens")
    public void setThens(List<GwtStepDto> thens) {
      this._thens = thens;
    }

    @Override
    public List<GwtStepDto> givens() { throw new UnsupportedOperationException(); }

    @Override
    public GwtStepDto when() { throw new UnsupportedOperationException(); }

    @Override
    public List<GwtStepDto> thens() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGwtScenarioDto fromJson(Json json) {
    ImmutableGwtScenarioDto.Builder builder = ImmutableGwtScenarioDto.builder();
    if (json._givens != null) {
      builder.addAllGivens(json._givens);
    }
    if (json._when != null) {
      builder.when(json._when);
    }
    if (json._thens != null) {
      builder.addAllThens(json._thens);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GwtScenarioDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GwtScenarioDto instance
   */
  public static ImmutableGwtScenarioDto copyOf(GwtScenarioDto instance) {
    if (instance instanceof ImmutableGwtScenarioDto) {
      return (ImmutableGwtScenarioDto) instance;
    }
    return ImmutableGwtScenarioDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGwtScenarioDto ImmutableGwtScenarioDto}.
   * <pre>
   * ImmutableGwtScenarioDto.builder()
   *    .addGivens|addAllGivens(fr.enedis.chutney.scenario.api.raw.dto.GwtStepDto) // {@link GwtScenarioDto#givens() givens} elements
   *    .when(fr.enedis.chutney.scenario.api.raw.dto.GwtStepDto) // required {@link GwtScenarioDto#when() when}
   *    .addThens|addAllThens(fr.enedis.chutney.scenario.api.raw.dto.GwtStepDto) // {@link GwtScenarioDto#thens() thens} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGwtScenarioDto builder
   */
  public static ImmutableGwtScenarioDto.Builder builder() {
    return new ImmutableGwtScenarioDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGwtScenarioDto ImmutableGwtScenarioDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GwtScenarioDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WHEN = 0x1L;
    private long initBits = 0x1L;

    private List<GwtStepDto> givens = new ArrayList<GwtStepDto>();
    private @Nullable GwtStepDto when;
    private List<GwtStepDto> thens = new ArrayList<GwtStepDto>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GwtScenarioDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GwtScenarioDto instance) {
      Objects.requireNonNull(instance, "instance");
      addAllGivens(instance.givens());
      this.when(instance.when());
      addAllThens(instance.thens());
      return this;
    }

    /**
     * Adds one element to {@link GwtScenarioDto#givens() givens} list.
     * @param element A givens element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGivens(GwtStepDto element) {
      this.givens.add(Objects.requireNonNull(element, "givens element"));
      return this;
    }

    /**
     * Adds elements to {@link GwtScenarioDto#givens() givens} list.
     * @param elements An array of givens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGivens(GwtStepDto... elements) {
      for (GwtStepDto element : elements) {
        this.givens.add(Objects.requireNonNull(element, "givens element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GwtScenarioDto#givens() givens} list.
     * @param elements An iterable of givens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "givens")
    public final Builder givens(Iterable<? extends GwtStepDto> elements) {
      this.givens.clear();
      return addAllGivens(elements);
    }

    /**
     * Adds elements to {@link GwtScenarioDto#givens() givens} list.
     * @param elements An iterable of givens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGivens(Iterable<? extends GwtStepDto> elements) {
      for (GwtStepDto element : elements) {
        this.givens.add(Objects.requireNonNull(element, "givens element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GwtScenarioDto#when() when} attribute.
     * @param when The value for when 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "when", required = true)
    public final Builder when(GwtStepDto when) {
      this.when = Objects.requireNonNull(when, "when");
      initBits &= ~INIT_BIT_WHEN;
      return this;
    }

    /**
     * Adds one element to {@link GwtScenarioDto#thens() thens} list.
     * @param element A thens element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addThens(GwtStepDto element) {
      this.thens.add(Objects.requireNonNull(element, "thens element"));
      return this;
    }

    /**
     * Adds elements to {@link GwtScenarioDto#thens() thens} list.
     * @param elements An array of thens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addThens(GwtStepDto... elements) {
      for (GwtStepDto element : elements) {
        this.thens.add(Objects.requireNonNull(element, "thens element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GwtScenarioDto#thens() thens} list.
     * @param elements An iterable of thens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "thens")
    public final Builder thens(Iterable<? extends GwtStepDto> elements) {
      this.thens.clear();
      return addAllThens(elements);
    }

    /**
     * Adds elements to {@link GwtScenarioDto#thens() thens} list.
     * @param elements An iterable of thens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllThens(Iterable<? extends GwtStepDto> elements) {
      for (GwtStepDto element : elements) {
        this.thens.add(Objects.requireNonNull(element, "thens element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGwtScenarioDto ImmutableGwtScenarioDto}.
     * @return An immutable instance of GwtScenarioDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGwtScenarioDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGwtScenarioDto(createUnmodifiableList(true, givens), when, createUnmodifiableList(true, thens));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WHEN) != 0) attributes.add("when");
      return "Cannot build GwtScenarioDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
