/*
 * SPDX-FileCopyrightText: 2017-2024 Enedis
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 */

import { ScenarioIndex } from '@model';
import { Pipe, PipeTransform } from '@angular/core';
import { containsAll } from '@shared/tools/array-utils';

@Pipe({
    name: 'scenarioCampaignSearch',
    standalone: false
})
export class ScenarioCampaignSearchPipe implements PipeTransform {

    transform(input: any, tags: String[]) {
        if (tags.length === 0) {
            return input;
        }

        return input.filter((item: ScenarioIndex) => {
            return (this.tagPresent(tags, item));
        });
    }

    private tagPresent(tags: String[], scenario: ScenarioIndex): boolean {
        return containsAll(tags, scenario.tags);
    }
}
