/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext;

import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.itext.ColorRegistry;
import org.apache.poi.xwpf.converter.internal.itext.TableWidth;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFTableUtil {
    public static float[] computeColWidths(XWPFTable table) {
        CTTblGrid grid;
        List cols;
        int nbCols = XWPFTableUtil.getNumberOfColumnFromFirstRow(table);
        if (nbCols > (cols = (grid = table.getCTTbl().getTblGrid()).getGridColList()).size()) {
            Collection<Float> maxColWidths = null;
            Collection<Float> currentColWidths = null;
            List rows = table.getRows();
            for (XWPFTableRow row : rows) {
                currentColWidths = XWPFTableUtil.computeColWidths(row);
                if (maxColWidths == null) {
                    maxColWidths = currentColWidths;
                    continue;
                }
                if (currentColWidths.size() <= maxColWidths.size()) continue;
                maxColWidths = currentColWidths;
            }
            float[] colWidths = new float[maxColWidths.size()];
            int i = 0;
            for (Float colWidth : maxColWidths) {
                colWidths[i++] = colWidth.floatValue();
            }
            return colWidths;
        }
        float[] colWidths = new float[cols.size()];
        float colWidth = -1.0f;
        for (int i = 0; i < colWidths.length; ++i) {
            CTTblGridCol tblGridCol = (CTTblGridCol)cols.get(i);
            colWidth = tblGridCol.getW().floatValue();
            colWidths[i] = DxaUtil.dxa2points(colWidth);
        }
        return colWidths;
    }

    public static int getNumberOfColumnFromFirstRow(XWPFTable table) {
        int nbCols = 0;
        int numberOfRows = table.getNumberOfRows();
        if (numberOfRows > 0) {
            XWPFTableRow firstRow = table.getRow(0);
            List tableCellsOffFirstRow = firstRow.getTableCells();
            for (XWPFTableCell tableCellOffFirstRow : tableCellsOffFirstRow) {
                CTDecimalNumber gridSpan = XWPFTableUtil.getGridSpan(tableCellOffFirstRow);
                if (gridSpan != null) {
                    nbCols += gridSpan.getVal().intValue();
                    continue;
                }
                ++nbCols;
            }
        }
        return nbCols;
    }

    public static CTDecimalNumber getGridSpan(XWPFTableCell cell) {
        if (cell.getCTTc().getTcPr() != null) {
            return cell.getCTTc().getTcPr().getGridSpan();
        }
        return null;
    }

    public static CTTblWidth getWidth(XWPFTableCell cell) {
        return cell.getCTTc().getTcPr().getTcW();
    }

    private static Collection<Float> computeColWidths(XWPFTableRow row) {
        ArrayList<Float> colWidths = new ArrayList<Float>();
        List cells = row.getTableCells();
        for (XWPFTableCell cell : cells) {
            CTTblWidth width = XWPFTableUtil.getWidth(cell);
            if (width == null) continue;
            int nb = 1;
            CTDecimalNumber gridSpan = XWPFTableUtil.getGridSpan(cell);
            TableWidth tableCellWidth = XWPFTableUtil.getTableWidth(cell);
            if (gridSpan != null) {
                nb = gridSpan.getVal().intValue();
            }
            for (int i = 0; i < nb; ++i) {
                colWidths.add(Float.valueOf(tableCellWidth.width / (float)nb));
            }
        }
        return colWidths;
    }

    public static TableWidth getTableWidth(XWPFTable table) {
        float width = 0.0f;
        boolean percentUnit = false;
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        if (tblPr.isSetTblW()) {
            CTTblWidth tblWidth = tblPr.getTblW();
            return XWPFTableUtil.getTableWidth(tblWidth);
        }
        return new TableWidth(width, percentUnit);
    }

    public static TableWidth getTableWidth(XWPFTableCell cell) {
        float width = 0.0f;
        boolean percentUnit = false;
        CTTcPr tblPr = cell.getCTTc().getTcPr();
        if (tblPr.isSetTcW()) {
            CTTblWidth tblWidth = tblPr.getTcW();
            return XWPFTableUtil.getTableWidth(tblWidth);
        }
        return new TableWidth(width, percentUnit);
    }

    public static TableWidth getTableWidth(CTTblWidth tblWidth) {
        boolean percentUnit;
        float width = tblWidth.getW().intValue();
        boolean bl = percentUnit = 2 == tblWidth.getType().intValue();
        width = percentUnit ? (width /= 100.0f) : DxaUtil.dxa2points(width);
        return new TableWidth(width, percentUnit);
    }

    public static void setBorder(CTBorder border, PdfPCell pdfPCell, int borderSide) {
        boolean noBorder;
        if (border == null) {
            return;
        }
        boolean bl = noBorder = STBorder.NONE == border.getVal();
        if (noBorder) {
            pdfPCell.disableBorderSide(borderSide);
        } else {
            float size = -1.0f;
            BigInteger borderSize = border.getSz();
            if (borderSize != null) {
                size = DxaUtil.dxa2points(borderSize);
            }
            Color borderColor = null;
            String hexColor = XWPFTableUtil.getBorderColor(border);
            if (hexColor != null) {
                borderColor = ColorRegistry.getInstance().getColor("0x" + hexColor);
            }
            switch (borderSide) {
                case 1: {
                    if (size != -1.0f) {
                        pdfPCell.setBorderWidthTop(size);
                    }
                    if (borderColor == null) break;
                    pdfPCell.setBorderColorTop(borderColor);
                    break;
                }
                case 2: {
                    if (size != -1.0f) {
                        pdfPCell.setBorderWidthBottom(size);
                    }
                    if (borderColor == null) break;
                    pdfPCell.setBorderColorBottom(borderColor);
                    break;
                }
                case 4: {
                    if (size != -1.0f) {
                        pdfPCell.setBorderWidthLeft(size);
                    }
                    if (borderColor == null) break;
                    pdfPCell.setBorderColorLeft(borderColor);
                    break;
                }
                case 8: {
                    if (size != -1.0f) {
                        pdfPCell.setBorderWidthRight(size);
                    }
                    if (borderColor == null) break;
                    pdfPCell.setBorderColorRight(borderColor);
                }
            }
        }
    }

    public static void setBorder(StyleBorder border, PdfPCell pdfPCell, int borderSide) {
        if (border == null) {
            return;
        }
        float size = -1.0f;
        BigInteger borderSize = border.getWidth();
        if (borderSize != null) {
            size = DxaUtil.dxa2points(borderSize);
        }
        Color borderColor = border.getColor();
        switch (borderSide) {
            case 1: {
                if (size != -1.0f) {
                    pdfPCell.setBorderWidthTop(size);
                }
                if (borderColor == null) break;
                pdfPCell.setBorderColorTop(borderColor);
                break;
            }
            case 2: {
                if (size != -1.0f) {
                    pdfPCell.setBorderWidthBottom(size);
                }
                if (borderColor == null) break;
                pdfPCell.setBorderColorBottom(borderColor);
                break;
            }
            case 4: {
                if (size != -1.0f) {
                    pdfPCell.setBorderWidthLeft(size);
                }
                if (borderColor == null) break;
                pdfPCell.setBorderColorLeft(borderColor);
                break;
            }
            case 8: {
                if (size != -1.0f) {
                    pdfPCell.setBorderWidthRight(size);
                }
                if (borderColor == null) break;
                pdfPCell.setBorderColorRight(borderColor);
            }
        }
    }

    public static String getBorderColor(CTBorder border) {
        if (border == null) {
            return null;
        }
        Node colorAttr = border.getDomNode().getAttributes().getNamedItemNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "color");
        if (colorAttr != null) {
            return ((Attr)colorAttr).getValue();
        }
        return null;
    }
}

