/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import fr.opensagres.xdocreport.itext.extension.ExtendedChapter;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.IParagraphFactory;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableParagraph;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableSection;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleParagraphProperties;

public class StylableChapter
extends ExtendedChapter
implements IStylableContainer {
    private final StylableDocument ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableChapter(StylableDocument ownerDocument, IStylableContainer parent, StylableParagraph title, int number) {
        super((Paragraph)title, number);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        super.setTriggerNewPage(false);
    }

    public void applyStyles(Object ele, Style style) {
        this.lastStyleApplied = style;
        StyleParagraphProperties paragraphProperties = style.getParagraphProperties();
        if (paragraphProperties != null) {
            // empty if block
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public void addElement(Element element) {
        super.add((Object)element);
    }

    public Section addSection(float indentation, Paragraph title, int numberDepth) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        StylableSection section = this.ownerDocument.createSection(this, (StylableParagraph)title, numberDepth);
        section.setIndentation(indentation);
        this.add(section);
        return section;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }

    protected IParagraphFactory getParagraphFactory() {
        return this.ownerDocument;
    }

    public IITextContainer getITextContainer() {
        return this.parent;
    }

    public void setITextContainer(IITextContainer container) {
    }
}

