/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.itext.XWPFFontRegistry;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.styles.FontInfos;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleParagraphProperties;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylableParagraph
extends ExtendedParagraph
implements IStylableContainer<XWPFParagraph> {
    private static final long serialVersionUID = 664309269352903329L;
    private final StylableDocument ownerDocument;
    private IStylableContainer<XWPFParagraph> parent;
    private Style lastStyleApplied = null;

    public StylableParagraph(StylableDocument ownerDocument, IStylableContainer<XWPFParagraph> parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public StylableParagraph(StylableDocument ownerDocument, Paragraph title, IStylableContainer<XWPFParagraph> parent) {
        super(title);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void addElement(Element element) {
        super.add((Object)element);
    }

    @Override
    public void applyStyles(XWPFParagraph p, Style style) {
        int spacingBefore;
        int firstLineIndent;
        int indentationRight;
        int indentationFirstLine;
        int indentationLeft;
        ParagraphAlignment paragraphAlignment;
        StyleParagraphProperties paragraphProperties;
        if (style != null && (paragraphProperties = style.getParagraphProperties()) != null) {
            Float lineHeight;
            int alignment;
            FontInfos fontInfos = paragraphProperties.getFontInfos();
            if (fontInfos != null) {
                Font font = XWPFFontRegistry.getRegistry().getFont(fontInfos.getFontFamily(), fontInfos.getFontEncoding(), fontInfos.getFontSize(), fontInfos.getFontStyle(), fontInfos.getFontColor());
                this.setFont(font);
            }
            if ((alignment = paragraphProperties.getAlignment()) != -1) {
                this.setAlignment(alignment);
            }
            if ((lineHeight = paragraphProperties.getLineHeight()) != null) {
                this.setLeading(lineHeight.floatValue() * super.getTotalLeading());
            }
            this.setIndentationRight(paragraphProperties.getIndentationRight());
            this.setIndentationLeft(paragraphProperties.getIndentationLeft());
            this.setFirstLineIndent(paragraphProperties.getIndentationFirstLine());
        }
        if ((paragraphAlignment = p.getAlignment()) != null) {
            int alignment = -1;
            switch (paragraphAlignment) {
                case LEFT: {
                    alignment = 0;
                    break;
                }
                case RIGHT: {
                    alignment = 2;
                    break;
                }
                case CENTER: {
                    alignment = 1;
                    break;
                }
                case BOTH: {
                    alignment = 3;
                    break;
                }
            }
            this.setAlignment(alignment);
        }
        if ((indentationLeft = p.getIndentationLeft()) > 0) {
            this.setIndentationLeft(indentationLeft);
        }
        if ((indentationFirstLine = p.getIndentationFirstLine()) > 0) {
            this.setFirstLineIndent(indentationFirstLine);
        }
        if ((indentationRight = p.getIndentationRight()) > 0) {
            this.setIndentationRight(indentationRight);
        }
        int left = p.getIndentationLeft();
        int right = p.getIndentationRight();
        if (right > 0) {
            this.setIndentationRight(DxaUtil.dxa2points(right));
        }
        if (left > 0) {
            this.setIndentationLeft(DxaUtil.dxa2points(left));
        }
        if ((firstLineIndent = p.getIndentationFirstLine()) > 0) {
            this.setFirstLineIndent(DxaUtil.dxa2points(firstLineIndent));
        }
        if ((spacingBefore = p.getSpacingBefore()) > 0) {
            this.setSpacingBefore(DxaUtil.dxa2points(spacingBefore));
        }
        if (p.getSpacingAfter() >= 0) {
            this.setSpacingAfter(DxaUtil.dxa2points(p.getSpacingAfter()));
        } else {
            this.setSpacingAfter(10.0f);
        }
        if (p.getCTP().getPPr() != null && p.getCTP().getPPr().getSpacing() != null && p.getCTP().getPPr().getSpacing().getLine() != null) {
            float leading = p.getCTP().getPPr().getSpacing().getLine().floatValue() / 240.0f;
            this.setMultipliedLeading(leading);
        }
        ParagraphAlignment alignment = p.getAlignment();
        switch (alignment) {
            case LEFT: {
                this.setAlignment(0);
                break;
            }
            case RIGHT: {
                this.setAlignment(2);
                break;
            }
            case CENTER: {
                this.setAlignment(1);
                break;
            }
            case BOTH: {
                this.setAlignment(3);
                break;
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public Element getElement() {
        return this;
    }
}

