/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableProperties;
import org.apache.poi.xwpf.usermodel.XWPFTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylableTable
extends ExtendedPdfPTable
implements IStylableContainer<XWPFTable> {
    private StyleBorder borderTop;
    private StyleBorder borderBottom;
    private StyleBorder borderLeft;
    private StyleBorder borderRight;
    private final StylableDocument ownerDocument;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableTable(StylableDocument ownerDocument, IStylableContainer parent, int numColumns) {
        super(numColumns);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    @Override
    public void applyStyles(XWPFTable ele, Style style) {
        StyleTableProperties tableProperties;
        this.lastStyleApplied = style;
        if (style != null && (tableProperties = style.getTableProperties()) != null && tableProperties.getWidth() != null) {
            super.setTotalWidth(tableProperties.getWidth().floatValue());
            super.setLockedWidth(true);
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public Element getElement() {
        return this;
    }

    public StyleBorder getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(StyleBorder borderTop) {
        this.borderTop = borderTop;
    }

    public StyleBorder getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(StyleBorder borderBottom) {
        this.borderBottom = borderBottom;
    }

    public StyleBorder getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(StyleBorder borderLeft) {
        this.borderLeft = borderLeft;
    }

    public StyleBorder getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(StyleBorder borderRight) {
        this.borderRight = borderRight;
    }
}

