/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import java.math.BigInteger;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;

public class StyleUtils {
    public static void applyStyles(StyleBorder border, PdfPCell cell) {
        if (border == null) {
            return;
        }
        switch (border.getBorderType()) {
            case ALL: {
                BigInteger width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(1);
                    cell.disableBorderSide(2);
                    cell.disableBorderSide(8);
                    cell.disableBorderSide(4);
                    break;
                }
                cell.enableBorderSide(1);
                cell.enableBorderSide(2);
                cell.enableBorderSide(8);
                cell.enableBorderSide(4);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColor(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidth((float)DxaUtil.dxa2points(width));
                break;
            }
            case BOTTOM: {
                BigInteger width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(2);
                    break;
                }
                cell.enableBorderSide(2);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorBottom(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthBottom((float)DxaUtil.dxa2points(width));
                break;
            }
            case LEFT: {
                BigInteger width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(4);
                    break;
                }
                cell.enableBorderSide(4);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorLeft(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthLeft((float)DxaUtil.dxa2points(width));
                break;
            }
            case RIGHT: {
                BigInteger width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(8);
                    break;
                }
                cell.enableBorderSide(8);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorRight(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthRight((float)DxaUtil.dxa2points(width));
                break;
            }
            case TOP: {
                BigInteger width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(1);
                    break;
                }
                cell.enableBorderSide(1);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorTop(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthTop((float)DxaUtil.dxa2points(width));
            }
        }
    }
}

