/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.styles;

import org.apache.poi.xwpf.converter.internal.itext.styles.StyleHeaderFooterProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StylePageLayoutProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleParagraphProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableCellProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableRowProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTextProperties;

public class Style {
    private final String styleName;
    private StylePageLayoutProperties pageLayoutProperties;
    private StyleHeaderFooterProperties headerProperties;
    private StyleHeaderFooterProperties footerProperties;
    private StyleParagraphProperties paragraphProperties;
    private StyleTextProperties textProperties;
    private StyleTableProperties tableProperties;
    private StyleTableRowProperties tableRowProperties;
    private StyleTableCellProperties tableCellProperties;

    public Style(String styleName) {
        this.styleName = styleName;
    }

    public void merge(Style style) {
        if (this.paragraphProperties == null) {
            if (style.getParagraphProperties() != null) {
                this.paragraphProperties = new StyleParagraphProperties(style.getParagraphProperties());
            }
        } else if (style.getParagraphProperties() != null) {
            this.paragraphProperties.merge(style.getParagraphProperties());
        }
        if (this.textProperties == null) {
            if (style.getTextProperties() != null) {
                this.textProperties = new StyleTextProperties(style.getTextProperties());
            }
        } else if (style.getTextProperties() != null) {
            this.textProperties.merge(style.getTextProperties());
        }
        if (this.tableProperties == null) {
            if (style.getTableProperties() != null) {
                this.tableProperties = new StyleTableProperties(style.getTableProperties());
            }
        } else if (style.getTableProperties() != null) {
            this.tableProperties.merge(style.getTableProperties());
        }
        if (this.tableCellProperties == null) {
            if (style.getTableCellProperties() != null) {
                this.tableCellProperties = new StyleTableCellProperties(style.getTableCellProperties());
            }
        } else if (style.getTableCellProperties() != null) {
            this.tableCellProperties.merge(style.getTableCellProperties());
        }
    }

    public StyleParagraphProperties getParagraphProperties() {
        return this.paragraphProperties;
    }

    public void setParagraphProperties(StyleParagraphProperties paragraphProperties) {
        this.paragraphProperties = paragraphProperties;
    }

    public StyleTextProperties getTextProperties() {
        return this.textProperties;
    }

    public void setTextProperties(StyleTextProperties textProperties) {
        this.textProperties = textProperties;
    }

    public StyleTableProperties getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(StyleTableProperties tableProperties) {
        this.tableProperties = tableProperties;
    }

    public StyleTableRowProperties getTableRowProperties() {
        return this.tableRowProperties;
    }

    public void setTableRowProperties(StyleTableRowProperties tableRowProperties) {
        this.tableRowProperties = tableRowProperties;
    }

    public StyleTableCellProperties getTableCellProperties() {
        return this.tableCellProperties;
    }

    public void setTableCellProperties(StyleTableCellProperties tableCellProperties) {
        this.tableCellProperties = tableCellProperties;
    }

    public StylePageLayoutProperties getPageLayoutProperties() {
        return this.pageLayoutProperties;
    }

    public void setPageLayoutProperties(StylePageLayoutProperties pageLayoutProperties) {
        this.pageLayoutProperties = pageLayoutProperties;
    }

    public StyleHeaderFooterProperties getHeaderProperties() {
        return this.headerProperties;
    }

    public void setHeaderProperties(StyleHeaderFooterProperties headerProperties) {
        this.headerProperties = headerProperties;
    }

    public StyleHeaderFooterProperties getFooterProperties() {
        return this.footerProperties;
    }

    public void setFooterProperties(StyleHeaderFooterProperties footerProperties) {
        this.footerProperties = footerProperties;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getMasterPageName() {
        return null;
    }
}

