/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.xhtml;

import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xwpf.converter.internal.itext.StyleEngineForIText;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;

public class OLDXHTMLMapper
implements XHTMLConstants {
    private static final Logger LOGGER = Logger.getLogger(StyleEngineForIText.class.getName());
    private CTDocDefaults defaults;
    private XWPFDocument document;
    private XHTMLPage writer = new XHTMLPage(1);

    public OLDXHTMLMapper(XWPFDocument document) {
        this.document = document;
        try {
            this.defaults = document.getStyle().getDocDefaults();
        }
        catch (XmlException e) {
            LOGGER.severe(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    private XWPFPictureData getPictureData(String blipId) {
        for (POIXMLDocumentPart part : this.document.getRelations()) {
            if (!part.getPackageRelationship().getId().equals(blipId)) continue;
            return (XWPFPictureData)part;
        }
        return null;
    }

    public void output(OutputStream os) throws Exception {
        try {
            List bodyElement = this.document.getBodyElements();
            for (IBodyElement iBodyElement : bodyElement) {
                this.visit(iBodyElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("iTextissues", e);
        }
        finally {
            this.writer.save(os);
        }
    }

    private void visit(IBodyElement iBodyElement) throws Exception {
        if (iBodyElement instanceof XWPFParagraph) {
            this.visit((IBodyElement)((XWPFParagraph)iBodyElement));
        } else if (iBodyElement instanceof XWPFTable) {
            // empty if block
        }
    }
}

