/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.xhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.xwpf.converter.IURIResolver;
import org.apache.poi.xwpf.converter.IXWPFConverter;
import org.apache.poi.xwpf.converter.XWPFConverterException;
import org.apache.poi.xwpf.converter.internal.AbstractXWPFConverter;
import org.apache.poi.xwpf.converter.internal.xhtml.XHTMLMapper;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPF2XHTMLConverter
extends AbstractXWPFConverter<XHTMLOptions> {
    private static final IXWPFConverter<XHTMLOptions> INSTANCE = new XWPF2XHTMLConverter();

    public static IXWPFConverter<XHTMLOptions> getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, XHTMLOptions options) throws XWPFConverterException, IOException {
        int indent = 0;
        IURIResolver resolver = IURIResolver.DEFAULT;
        if (options != null) {
            indent = options.getIndent();
            if (options.getURIResolver() != null) {
                resolver = options.getURIResolver();
            }
        }
        XHTMLMapper mapper = new XHTMLMapper(document, indent, resolver);
        try {
            mapper.visit(out);
        }
        catch (Exception e) {
            throw new XWPFConverterException(e);
        }
    }
}

