/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.SettingsFinder;
import fr.pilato.elasticsearch.tools.util.SettingsReader;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIndexTemplateUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchIndexTemplateUpdater.class);

    public static void createIndexTemplate(RestClient client, String root, String template) throws Exception {
        String json = SettingsReader.getJsonContent(root, SettingsFinder.Defaults.IndexTemplatesDir, template);
        ElasticsearchIndexTemplateUpdater.createIndexTemplateWithJsonInElasticsearch(client, template, json);
    }

    private static void createIndexTemplateWithJsonInElasticsearch(RestClient client, String template, String json) throws Exception {
        logger.trace("createIndexTemplate([{}])", (Object)template);
        assert (client != null);
        assert (template != null);
        Request request = new Request("PUT", "/_index_template/" + template);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create index template [{}]", (Object)template);
            throw new Exception("Could not create index template [" + template + "].");
        }
        logger.trace("/createIndexTemplate([{}])", (Object)template);
    }
}

