/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import fr.pilato.elasticsearch.tools.updaters.ElasticsearchAliasUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchComponentTemplateUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchDataUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexLifecycleUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexTemplateUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchPipelineUpdater;
import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import fr.pilato.elasticsearch.tools.util.ResourceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBeyonder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchBeyonder.class);

    private ElasticsearchBeyonder() {
    }

    public static void start(RestClient client) throws Exception {
        ElasticsearchBeyonder.start(client, DefaultSettings.ConfigDir, DefaultSettings.ForceCreation);
    }

    public static void start(RestClient client, String root) throws Exception {
        ElasticsearchBeyonder.start(client, root, DefaultSettings.ForceCreation);
    }

    public static void start(RestClient client, String root, boolean force) throws Exception {
        logger.info("starting automatic settings/mappings discovery");
        List<String> indexLifecycles = ResourceList.getResourceNames(root, DefaultSettings.IndexLifecyclesDir);
        for (String string : indexLifecycles) {
            ElasticsearchIndexLifecycleUpdater.createIndexLifecycle(client, root, string);
        }
        List<String> componentTemplates = ResourceList.getResourceNames(root, DefaultSettings.ComponentTemplatesDir);
        for (String string : componentTemplates) {
            ElasticsearchComponentTemplateUpdater.createComponentTemplate(client, root, string);
        }
        List<String> list = ResourceList.getResourceNames(root, DefaultSettings.IndexTemplatesDir);
        for (String string : list) {
            ElasticsearchIndexTemplateUpdater.createIndexTemplate(client, root, string);
        }
        List<String> list2 = ResourceList.getResourceNames(root, DefaultSettings.PipelinesDir);
        for (String pipelineName : list2) {
            ElasticsearchPipelineUpdater.createPipeline(client, root, pipelineName);
        }
        List<String> list3 = ResourceList.findIndexNames(root);
        ArrayList<String> createdIndices = new ArrayList<String>();
        for (String indexName : list3) {
            if (ElasticsearchIndexUpdater.createIndex(client, root, indexName, force)) {
                createdIndices.add(indexName);
            }
            ElasticsearchIndexUpdater.updateSettings(client, root, indexName);
            ElasticsearchIndexUpdater.updateMapping(client, root, indexName);
        }
        ElasticsearchAliasUpdater.manageAliases(client, root);
        for (String indexName : createdIndices) {
            Collection<String> bulkFiles = ResourceList.findBulkFiles(root, indexName);
            ElasticsearchDataUpdater.loadBulkData(client, root, indexName, bulkFiles);
            Collection<String> singleFiles = ResourceList.findJsonFiles(root, indexName);
            ElasticsearchDataUpdater.loadJsonData(client, root, indexName, singleFiles);
        }
        Collection<String> bulkFiles = ResourceList.findBulkFiles(root, null);
        ElasticsearchDataUpdater.loadBulkData(client, root, null, bulkFiles);
        logger.info("start done. Rock & roll!");
    }
}

