/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import fr.pilato.elasticsearch.tools.util.SettingsReader;
import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchPipelineUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchPipelineUpdater.class);

    private ElasticsearchPipelineUpdater() {
    }

    public static void createPipeline(RestClient client, String root, String pipeline) throws Exception {
        String json = SettingsReader.getJsonContent(root, DefaultSettings.PipelinesDir, pipeline + DefaultSettings.JsonFileExtension);
        ElasticsearchPipelineUpdater.createPipelineWithJsonInElasticsearch(client, pipeline, json);
    }

    private static void createPipelineWithJsonInElasticsearch(RestClient client, String pipeline, String json) throws Exception {
        logger.trace("createPipeline([{}])", (Object)pipeline);
        assert (client != null);
        assert (pipeline != null);
        Request request = new Request("PUT", "/_ingest/pipeline/" + pipeline);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create pipeline [{}]", (Object)pipeline);
            throw new Exception("Could not create pipeline [" + pipeline + "].");
        }
        logger.trace("/createPipeline([{}])", (Object)pipeline);
    }

    public static boolean isPipelineExist(RestClient client, String pipeline) throws IOException {
        try {
            Response response = client.performRequest(new Request("GET", "/_ingest/pipeline/" + pipeline));
            return response.getEntity() != null;
        }
        catch (ResponseException e) {
            if (404 != e.getResponse().getStatusLine().getStatusCode()) {
                throw e;
            }
            return false;
        }
    }
}

