/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.SettingsReader;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIndexLifecycleUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchIndexLifecycleUpdater.class);

    private ElasticsearchIndexLifecycleUpdater() {
    }

    public static void createIndexLifecycle(RestClient client, String root, String policy) throws Exception {
        String json = SettingsReader.getJsonContent(root, "_index_lifecycles", policy + ".json");
        ElasticsearchIndexLifecycleUpdater.createIndexLifecycleWithJsonInElasticsearch(client, policy, json);
    }

    private static void createIndexLifecycleWithJsonInElasticsearch(RestClient client, String policy, String json) throws Exception {
        logger.trace("createIndexLifecycle([{}])", (Object)policy);
        assert (client != null);
        assert (policy != null);
        Request request = new Request("PUT", "/_ilm/policy/" + policy);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create index lifecycle policy [{}]", (Object)policy);
            throw new Exception("Could not create index lifecycle policy [" + policy + "].");
        }
        logger.trace("/createIndexTemplate([{}])", (Object)policy);
    }
}

