/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;

public class IOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            String string = IOUtil.readString(in);
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url) throws IOException {
        Reader reader = IOUtil.urlToReader(url);
        try {
            String string = IOUtil.readString(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readString(InputStream in) throws IOException {
        return IOUtil.readString(new InputStreamReader(in));
    }

    public static String readString(Reader r) throws IOException {
        return IOUtil.readFully(r).toString();
    }

    public static String readString(Reader r, int maxChars) throws IOException {
        char[] charBuf = new char[maxChars];
        int charsRead = IOUtil.readChars(r, charBuf);
        return new String(charBuf, 0, charsRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readChars(URL url) throws IOException {
        Reader reader = IOUtil.urlToReader(url);
        try {
            char[] cArray = IOUtil.readChars(reader);
            return cArray;
        }
        finally {
            reader.close();
        }
    }

    public static char[] readChars(Reader r) throws IOException {
        return IOUtil.readFully(r).toCharArray();
    }

    public static int readChars(Reader r, char[] charArray) throws IOException {
        int totalCharsRead = 0;
        int charsRead = r.read(charArray);
        while (charsRead >= 0 && (totalCharsRead += charsRead) != charArray.length) {
            charsRead = r.read(charArray, totalCharsRead, charArray.length - totalCharsRead);
        }
        return totalCharsRead;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtil.transfer(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        byte[] result = new byte[maxBytes];
        int bytesRead = IOUtil.readBytes(in, result);
        if (bytesRead < maxBytes) {
            byte[] tmp = new byte[bytesRead];
            System.arraycopy(result, 0, tmp, 0, bytesRead);
            result = tmp;
        }
        return result;
    }

    public static int readBytes(InputStream in, byte[] byteArray) throws IOException {
        int totalBytesRead = 0;
        int bytesRead = in.read(byteArray);
        while (bytesRead >= 0 && (totalBytesRead += bytesRead) != byteArray.length) {
            bytesRead = in.read(byteArray, totalBytesRead, byteArray.length - totalBytesRead);
        }
        return totalBytesRead;
    }

    public static Properties readProperties(File propsFile) throws IOException {
        return IOUtil.readProperties(propsFile, null);
    }

    public static Properties readProperties(File propsFile, Properties defaults) throws IOException {
        return IOUtil.readProperties(new FileInputStream(propsFile), defaults);
    }

    public static Properties readProperties(InputStream in) throws IOException {
        return IOUtil.readProperties(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(InputStream in, Properties defaults) throws IOException {
        Properties result = new Properties(defaults);
        try {
            result.load(in);
        }
        finally {
            in.close();
        }
        return result;
    }

    public static void writeProperties(Properties props, File file, boolean includeDefaults) throws IOException {
        IOUtil.writeProperties(props, new FileOutputStream(file), includeDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(Properties props, OutputStream out, boolean includeDefaults) throws IOException {
        if (includeDefaults) {
            Properties all = new Properties();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                all.put(propName, propValue);
            }
            props = all;
        }
        try {
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtil.transfer(in, out);
        }
        finally {
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String contents, File file) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            out.write(contents);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(byte[] data, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtil.writeBytes(data, out);
        }
        finally {
            out.close();
        }
    }

    public static void writeBytes(byte[] data, OutputStream out) throws IOException {
        IOUtil.transfer((InputStream)new ByteArrayInputStream(data), out);
    }

    public static Reader urlToReader(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return new InputStreamReader(con.getInputStream());
    }

    private static CharArrayWriter readFully(Reader r) throws IOException {
        CharArrayWriter result = new CharArrayWriter();
        char[] buf = new char[4096];
        int charsRead = 0;
        while ((charsRead = r.read(buf)) != -1) {
            result.write(buf, 0, charsRead);
        }
        return result;
    }

    public static final long transfer(InputStream in, OutputStream out) throws IOException {
        long totalBytes = 0L;
        int bytesInBuf = 0;
        byte[] buf = new byte[4096];
        while ((bytesInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, bytesInBuf);
            totalBytes += (long)bytesInBuf;
        }
        return totalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transfer(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            long l = IOUtil.transfer(in, out);
            return l;
        }
        finally {
            out.close();
        }
    }

    public static final long transfer(Reader in, Writer out) throws IOException {
        long totalChars = 0L;
        int charsInBuf = 0;
        char[] buf = new char[4096];
        while ((charsInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, charsInBuf);
            totalChars += (long)charsInBuf;
        }
        return totalChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transfer(Reader reader, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            long l = IOUtil.transfer(reader, writer);
            return l;
        }
        finally {
            writer.close();
        }
    }
}

