/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedPropertyType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.ArrayList;
import java.util.List;

public class ChangePropertyTypeCommand
extends AbstractCommand {
    public NodePath _propPath;
    public String _propName;
    public SimplifiedPropertyType _newType;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldProperty;
    public boolean _oldRequired;
    public boolean _nullRequired;

    ChangePropertyTypeCommand() {
    }

    ChangePropertyTypeCommand(IPropertySchema property, SimplifiedPropertyType newType) {
        this._propPath = Library.createNodePath((Node)((Object)property));
        this._propName = property.getPropertyName();
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangePropertyTypeCommand] Executing: " + this._newType, new Object[0]);
        IPropertySchema prop = (IPropertySchema)((Object)this._propPath.resolve(document));
        if (this.isNullOrUndefined(prop)) {
            return;
        }
        OasSchema parent = (OasSchema)((Node)((Object)prop)).parent();
        List<String> required = parent.required;
        this._oldProperty = Library.writeNode((Node)((Object)prop));
        this._oldRequired = ModelUtils.isDefined(required) && required.size() > 0 && required.indexOf(prop.getPropertyName()) != -1;
        SimplifiedTypeUtil.setSimplifiedType((OasSchema)((Object)prop), this._newType);
        if (!this.isNullOrUndefined(this._newType.required)) {
            if (this._newType.required.booleanValue() && !this._oldRequired) {
                if (this.isNullOrUndefined(required)) {
                    parent.required = required = new ArrayList<String>();
                    this._nullRequired = true;
                }
                required.add(prop.getPropertyName());
            }
            if (!this._newType.required.booleanValue() && this._oldRequired) {
                required.remove(required.indexOf(prop.getPropertyName()));
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangePropertyTypeCommand] Reverting.", new Object[0]);
        IPropertySchema prop = (IPropertySchema)((Object)this._propPath.resolve(document));
        if (this.isNullOrUndefined(prop)) {
            return;
        }
        OasSchema parent = (OasSchema)((Node)((Object)prop)).parent();
        List<String> required = parent.required;
        boolean wasRequired = ModelUtils.isDefined(required) && required.size() > 0 && required.indexOf(prop.getPropertyName()) != -1;
        OasSchema oldProp = parent.createPropertySchema(this._propName);
        Library.readNode(this._oldProperty, oldProp);
        OasSchema sprop = (OasSchema)((Object)prop);
        sprop.$ref = null;
        sprop.type = null;
        sprop.enum_ = null;
        sprop.format = null;
        sprop.items = null;
        if (ModelUtils.isDefined(oldProp)) {
            sprop.$ref = oldProp.$ref;
            sprop.type = oldProp.type;
            sprop.enum_ = oldProp.enum_;
            sprop.format = oldProp.format;
            sprop.items = oldProp.items;
            if (ModelUtils.isDefined(sprop.items) && !NodeCompat.isList(sprop.items)) {
                Node itemsNode = (Node)sprop.items;
                itemsNode._parent = sprop;
                itemsNode._ownerDocument = sprop.ownerDocument();
            }
        }
        if (!this.isNullOrUndefined(this._newType.required)) {
            if (this._nullRequired) {
                parent.required = null;
            } else {
                if (wasRequired && !this._oldRequired) {
                    required.remove(required.indexOf(prop.getPropertyName()));
                }
                if (!wasRequired && this._oldRequired) {
                    required.add(prop.getPropertyName());
                }
            }
        }
    }
}

