/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.parameterstore;

import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreProperties;
import io.awspring.cloud.autoconfigure.config.parameterstore.SsmClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.services.ssm.SsmClient;

@AutoConfiguration
@EnableConfigurationProperties(value={ParameterStoreProperties.class})
@ConditionalOnClass(value={SsmClient.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class, AwsAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.parameterstore.enabled"}, havingValue="true", matchIfMissing=true)
public class ParameterStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SsmClient ssmClient(ParameterStoreProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<SsmClientCustomizer> ssmClientCustomizers, ObjectProvider<AwsSyncClientCustomizer> awsSyncClientCustomizers, ObjectProvider<AwsConnectionDetails> connectionDetails) {
        return (SsmClient)awsClientBuilderConfigurer.configureSyncClient(SsmClient.builder(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), ssmClientCustomizers.orderedStream(), awsSyncClientCustomizers.orderedStream()).build();
    }
}

