/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3;

import io.awspring.cloud.autoconfigure.s3.S3AutoConfiguration;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import io.awspring.cloud.autoconfigure.s3.properties.S3TransferManagerProperties;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.TransferManagerS3OutputStreamProvider;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

@AutoConfiguration
@ConditionalOnClass(value={S3TransferManager.class, S3OutputStreamProvider.class})
@EnableConfigurationProperties(value={S3Properties.class})
@ConditionalOnProperty(name={"spring.cloud.aws.s3.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={S3AutoConfiguration.class})
public class S3TransferManagerAutoConfiguration {
    private final S3Properties properties;

    public S3TransferManagerAutoConfiguration(S3Properties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    S3TransferManager s3TransferManager(ObjectProvider<S3AsyncClient> s3AsyncClient) {
        S3TransferManager.Builder builder = S3TransferManager.builder();
        if (this.properties.getTransferManager() != null) {
            S3TransferManagerProperties transferManagerProperties = this.properties.getTransferManager();
            PropertyMapper propertyMapper = PropertyMapper.get();
            propertyMapper.from(transferManagerProperties::getMaxDepth).to(arg_0 -> ((S3TransferManager.Builder)builder).uploadDirectoryMaxDepth(arg_0));
            propertyMapper.from(transferManagerProperties::getFollowSymbolicLinks).to(arg_0 -> ((S3TransferManager.Builder)builder).uploadDirectoryFollowSymbolicLinks(arg_0));
        }
        return builder.s3Client((S3AsyncClient)s3AsyncClient.getIfAvailable()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    S3OutputStreamProvider transferManagerS3StreamProvider(S3TransferManager s3TransferManager, Optional<S3ObjectContentTypeResolver> contentTypeResolver) {
        return new TransferManagerS3OutputStreamProvider(s3TransferManager, contentTypeResolver.orElseGet(PropertiesS3ObjectContentTypeResolver::new));
    }
}

