/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.sqs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.AwsAsyncClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.sqs.SqsAsyncClientCustomizer;
import io.awspring.cloud.autoconfigure.sqs.SqsProperties;
import io.awspring.cloud.sqs.config.SqsBootstrapConfiguration;
import io.awspring.cloud.sqs.config.SqsListenerConfigurer;
import io.awspring.cloud.sqs.config.SqsMessageListenerContainerFactory;
import io.awspring.cloud.sqs.listener.SqsContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import io.awspring.cloud.sqs.operations.SqsTemplate;
import io.awspring.cloud.sqs.operations.SqsTemplateBuilder;
import io.awspring.cloud.sqs.support.converter.MessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.SqsMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.legacy.JacksonJsonMessageConverterMigration;
import io.awspring.cloud.sqs.support.converter.legacy.JacksonMessageConverterMigration;
import io.awspring.cloud.sqs.support.converter.legacy.LegacyJackson2MessageConverterMigration;
import io.awspring.cloud.sqs.support.converter.legacy.LegacyJackson2SqsMessagingMessageConverter;
import io.awspring.cloud.sqs.support.observation.SqsListenerObservation;
import io.awspring.cloud.sqs.support.observation.SqsTemplateObservation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.Message;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnClass(value={SqsAsyncClient.class, SqsBootstrapConfiguration.class})
@EnableConfigurationProperties(value={SqsProperties.class})
@Import(value={SqsBootstrapConfiguration.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.sqs.enabled"}, havingValue="true", matchIfMissing=true)
public class SqsAutoConfiguration {
    private final SqsProperties sqsProperties;

    public SqsAutoConfiguration(SqsProperties sqsProperties) {
        this.sqsProperties = sqsProperties;
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsAsyncClient sqsAsyncClient(AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<SqsAsyncClientCustomizer> sqsAsyncClientCustomizers, ObjectProvider<AwsAsyncClientCustomizer> awsAsyncClientCustomizers) {
        return (SqsAsyncClient)awsClientBuilderConfigurer.configureAsyncClient(SqsAsyncClient.builder(), this.sqsProperties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), sqsAsyncClientCustomizers.orderedStream(), awsAsyncClientCustomizers.orderedStream()).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsTemplate sqsTemplate(SqsAsyncClient sqsAsyncClient, ObjectProvider<JacksonMessageConverterMigration> messageConverterFactory, ObjectProvider<ObservationRegistry> observationRegistryProvider, ObjectProvider<SqsTemplateObservation.Convention> observationConventionProvider, MessagingMessageConverter<Message> messageConverter) {
        SqsTemplateBuilder builder = SqsTemplate.builder().sqsAsyncClient(sqsAsyncClient).messageConverter(messageConverter);
        messageConverterFactory.ifAvailable(mcf -> mcf.configureLegacyObjectMapper(messageConverter));
        if (this.sqsProperties.isObservationEnabled().booleanValue()) {
            observationRegistryProvider.ifAvailable(registry -> builder.configure(options -> options.observationRegistry(registry)));
            observationConventionProvider.ifAvailable(convention -> builder.configure(options -> options.observationConvention(convention)));
        }
        if (this.sqsProperties.getQueueNotFoundStrategy() != null) {
            builder.configure(options -> options.queueNotFoundStrategy(this.sqsProperties.getQueueNotFoundStrategy()));
        }
        return builder.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsMessageListenerContainerFactory<Object> defaultSqsListenerContainerFactory(ObjectProvider<SqsAsyncClient> sqsAsyncClient, ObjectProvider<AsyncErrorHandler<Object>> asyncErrorHandler, ObjectProvider<ErrorHandler<Object>> errorHandler, ObjectProvider<AsyncMessageInterceptor<Object>> asyncInterceptors, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<SqsListenerObservation.Convention> observationConventionProvider, ObjectProvider<MessageInterceptor<Object>> interceptors, ObjectProvider<JacksonMessageConverterMigration> messageConverterFactory, MessagingMessageConverter<?> messagingMessageConverter) {
        SqsMessageListenerContainerFactory factory = new SqsMessageListenerContainerFactory();
        factory.configure(this::configureProperties);
        sqsAsyncClient.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setSqsAsyncClient(arg_0));
        asyncErrorHandler.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setErrorHandler(arg_0));
        errorHandler.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setErrorHandler(arg_0));
        interceptors.forEach(arg_0 -> ((SqsMessageListenerContainerFactory)factory).addMessageInterceptor(arg_0));
        asyncInterceptors.forEach(arg_0 -> ((SqsMessageListenerContainerFactory)factory).addMessageInterceptor(arg_0));
        messageConverterFactory.ifAvailable(mcf -> mcf.configureLegacyObjectMapper(messagingMessageConverter));
        if (this.sqsProperties.isObservationEnabled().booleanValue()) {
            observationRegistry.ifAvailable(registry -> factory.configure(options -> options.observationRegistry(registry)));
            observationConventionProvider.ifAvailable(convention -> factory.configure(options -> options.observationConvention(convention)));
        }
        factory.configure(options -> options.messageConverter(messagingMessageConverter));
        return factory;
    }

    private void configureProperties(SqsContainerOptionsBuilder options) {
        PropertyMapper mapper = PropertyMapper.get();
        mapper.from((Object)this.sqsProperties.getQueueNotFoundStrategy()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).queueNotFoundStrategy(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getMaxConcurrentMessages()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).maxConcurrentMessages(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getMaxMessagesPerPoll()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).maxMessagesPerPoll(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getPollTimeout()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).pollTimeout(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getMaxDelayBetweenPolls()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).maxDelayBetweenPolls(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getAutoStartup()).to(arg_0 -> ((SqsContainerOptionsBuilder)options).autoStartup(arg_0));
    }

    @Bean
    public SqsListenerConfigurer jacksonMessageConverterMigrationCustomizer(ObjectProvider<JacksonMessageConverterMigration> factoryProvider) {
        JacksonMessageConverterMigration factory = (JacksonMessageConverterMigration)factoryProvider.getIfUnique();
        return registrar -> {
            if (factory != null && registrar.getJacksonMessageConverterMigration() == null) {
                registrar.setJacksonMessageConverterMigration(factory);
            }
        };
    }

    @ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
    @ConditionalOnMissingClass(value={"tools.jackson.databind.json.JsonMapper"})
    @Configuration
    static class LegacySqsJackson2Configuration {
        LegacySqsJackson2Configuration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public MessagingMessageConverter<Message> messageConverter() {
            return new LegacyJackson2SqsMessagingMessageConverter();
        }

        @Bean
        @ConditionalOnMissingBean
        public JacksonMessageConverterMigration legacyJackson2messageConverter(ObjectProvider<ObjectMapper> objectMapper) {
            ObjectMapper mapper = (ObjectMapper)objectMapper.getIfAvailable(ObjectMapper::new);
            return new LegacyJackson2MessageConverterMigration(mapper);
        }
    }

    @ConditionalOnClass(name={"tools.jackson.databind.json.JsonMapper"})
    @Configuration
    static class SqsJacksonConfiguration {
        SqsJacksonConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public MessagingMessageConverter<Message> messageConverter() {
            return new SqsMessagingMessageConverter();
        }

        @Bean
        @ConditionalOnMissingBean
        public JacksonMessageConverterMigration jsonMapperWrapper(ObjectProvider<JsonMapper> jsonMapper) {
            JsonMapper mapper = (JsonMapper)jsonMapper.getIfAvailable(JsonMapper::new);
            return new JacksonJsonMessageConverterMigration(mapper);
        }
    }
}

