/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectConverter;
import java.io.InputStream;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.sync.RequestBody;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.json.JsonMapper;

public class Jackson2JsonS3ObjectConverter
implements S3ObjectConverter {
    private final JsonMapper jsonMapper;

    public Jackson2JsonS3ObjectConverter(JsonMapper jsonMapper) {
        Assert.notNull((Object)jsonMapper, (String)"jsonMapper is required");
        this.jsonMapper = jsonMapper;
    }

    @Override
    public <T> RequestBody write(T object) {
        Assert.notNull(object, (String)"object is required");
        try {
            return RequestBody.fromBytes((byte[])this.jsonMapper.writeValueAsBytes(object));
        }
        catch (JacksonException e) {
            throw new S3Exception("Failed to serialize object to JSON", e);
        }
    }

    @Override
    public <T> T read(InputStream is, Class<T> clazz) {
        Assert.notNull((Object)is, (String)"InputStream is required");
        Assert.notNull(clazz, (String)"Clazz is required");
        try {
            return (T)this.jsonMapper.readValue(is, clazz);
        }
        catch (JacksonException e) {
            throw new S3Exception("Failed to deserialize object from JSON", e);
        }
    }

    @Override
    public String contentType() {
        return "application/json";
    }
}

