/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3.integration;

import java.util.Date;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3FileInfo
extends AbstractFileInfo<S3Object> {
    private final S3Object s3Object;

    public S3FileInfo(S3Object s3Object) {
        Assert.notNull((Object)s3Object, (String)"s3Object must not be null");
        this.s3Object = s3Object;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public long getSize() {
        return this.s3Object.size();
    }

    public long getModified() {
        return this.s3Object.lastModified().getEpochSecond();
    }

    public String getFilename() {
        return this.s3Object.key();
    }

    public String getPermissions() {
        throw new UnsupportedOperationException("Use [AmazonS3.getObjectAcl()] to obtain permissions.");
    }

    public S3Object getFileInfo() {
        return this.s3Object;
    }

    public String toString() {
        return "FileInfo [isDirectory=" + this.isDirectory() + ", isLink=" + this.isLink() + ", Size=" + this.getSize() + ", ModifiedTime=" + new Date(this.getModified()) + ", Filename=" + this.getFilename() + ", RemoteDirectory=" + this.getRemoteDirectory() + "]";
    }
}

