/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.protocol.record.value.ExecutionListenerEventType;
import java.util.Collection;

public final class ExecutionListenerTransformer {
    public void transform(ExecutableFlowNode executableFlowNode, Collection<ZeebeExecutionListener> executionListeners, ExpressionLanguage expressionLanguage) {
        executionListeners.forEach(listener -> this.addListenerToFlowNode((ZeebeExecutionListener)listener, executableFlowNode, expressionLanguage));
    }

    private void addListenerToFlowNode(ZeebeExecutionListener listener, ExecutableFlowNode flowNode, ExpressionLanguage expressionLanguage) {
        flowNode.addListener(this.fromZeebeExecutionListenerEventType(listener.getEventType()), expressionLanguage.parseExpression(listener.getType()), expressionLanguage.parseExpression(listener.getRetries()));
    }

    private ExecutionListenerEventType fromZeebeExecutionListenerEventType(ZeebeExecutionListenerEventType eventType) {
        return switch (eventType) {
            default -> throw new MatchException(null, null);
            case ZeebeExecutionListenerEventType.start -> ExecutionListenerEventType.START;
            case ZeebeExecutionListenerEventType.end -> ExecutionListenerEventType.END;
        };
    }
}

