/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface AuthorizePolicy {
    public static final NoMatchingRule ALLOW_ON_NO_RULE = new NoMatchingRule(PolicyType.ALLOW_ON_NO_RULE);
    public static final NoMatchingRule DENY_ON_NO_RULE = new NoMatchingRule(PolicyType.DENY_ON_NO_RULE);
    public static final NoMatchingRule NO_MATCHING_RULE = new NoMatchingRule(PolicyType.NO_MATCHING_RULE);

    public PolicyType policyType();

    public static class NoMatchingRule
    implements AuthorizePolicy {
        private final PolicyType authorizeType;

        public NoMatchingRule(PolicyType authorizeType) {
            if (authorizeType != PolicyType.ALLOW_ON_NO_RULE && authorizeType != PolicyType.DENY_ON_NO_RULE && authorizeType != PolicyType.NO_MATCHING_RULE) {
                throw new IllegalArgumentException("Invalid authorizeType " + String.valueOf((Object)authorizeType));
            }
            this.authorizeType = authorizeType;
        }

        @Override
        public PolicyType policyType() {
            return this.authorizeType;
        }

        public String toString() {
            return "NoMatchingRule(authorizeType=" + String.valueOf((Object)this.authorizeType) + ")";
        }
    }

    public static enum PolicyType {
        SUPER_USER(true),
        SUPER_GROUP(true),
        BROKER_USER(true),
        ALLOW_ON_NO_RULE(true),
        DENY_ON_NO_RULE(false),
        ALLOW_ACL(true),
        DENY_ACL(false),
        ALLOW_ROLE(true),
        NO_MATCHING_RULE(false),
        UNKNOWN(false);

        private final boolean accessGranted;

        private PolicyType(boolean accessGranted) {
            this.accessGranted = accessGranted;
        }

        public boolean accessGranted() {
            return this.accessGranted;
        }
    }

    public static class BrokerUser
    implements AuthorizePolicy {
        private final PolicyType authorizeType;
        private final KafkaPrincipal principal;

        public BrokerUser(PolicyType authorizeType, KafkaPrincipal principal) {
            if (authorizeType != PolicyType.BROKER_USER) {
                throw new IllegalArgumentException("Invalid authorizeType " + String.valueOf((Object)authorizeType));
            }
            this.authorizeType = authorizeType;
            this.principal = principal;
        }

        @Override
        public PolicyType policyType() {
            return this.authorizeType;
        }

        public KafkaPrincipal principal() {
            return this.principal;
        }

        public String toString() {
            return "BrokerUser(authorizeType=" + String.valueOf((Object)this.authorizeType) + ", principal=" + String.valueOf(this.principal) + ")";
        }
    }

    public static class SuperUser
    implements AuthorizePolicy {
        private final PolicyType authorizeType;
        private final KafkaPrincipal principal;

        public SuperUser(PolicyType authorizeType, KafkaPrincipal principal) {
            if (authorizeType != PolicyType.SUPER_USER && authorizeType != PolicyType.SUPER_GROUP) {
                throw new IllegalArgumentException("Invalid authorizeType " + String.valueOf((Object)authorizeType));
            }
            this.authorizeType = authorizeType;
            this.principal = principal;
        }

        @Override
        public PolicyType policyType() {
            return this.authorizeType;
        }

        public KafkaPrincipal principal() {
            return this.principal;
        }

        public String toString() {
            return "SuperUser(authorizeType=" + String.valueOf((Object)this.authorizeType) + ", principal=" + String.valueOf(this.principal) + ")";
        }
    }
}

