/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;

public class ClientSecuritySpec {
    public final String bootstrapServers;
    public final SecurityProtocol securityProtocol;
    public final String saslMechanism;
    public final String jaasConfig;
    private final Properties additionalProps;

    public ClientSecuritySpec(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties properties) {
        this.bootstrapServers = bootstrapServers;
        this.securityProtocol = securityProtocol;
        this.saslMechanism = saslMechanism;
        this.jaasConfig = jaasConfig;
        this.additionalProps = properties;
    }

    public ClientSecuritySpec(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        this(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, new Properties());
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.put("security.protocol", this.securityProtocol.name);
        props.put("bootstrap.servers", this.bootstrapServers);
        if (this.saslMechanism != null) {
            props.put("sasl.jaas.config", this.jaasConfig);
            props.put("sasl.mechanism", this.saslMechanism);
        }
        props.putAll((Map<?, ?>)this.additionalProps);
        return props;
    }

    public String writePropertiesAsTempFile() {
        try {
            Properties props = this.toProperties();
            File tempFile = TestUtils.tempFile();
            try (FileWriter writer = new FileWriter(tempFile);){
                props.store(writer, "");
            }
            return tempFile.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write properties to temp file", e);
        }
    }

    public static ClientSecuritySpec plaintext(String bootstrapServers) {
        return new ClientSecuritySpec(bootstrapServers, SecurityProtocol.PLAINTEXT, null, null);
    }
}

