/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.metrics.HotPartitionManager;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;

public class MultiTenantInterceptor
implements BrokerInterceptor {
    private final Time time;
    private final TenantMetrics tenantMetrics;
    private final HotPartitionManager hotPartitionManager;
    private Optional<ClusterLinkSourceMetrics> clusterLinkSourceMetrics;
    private MultiTenantInterceptorConfig multiTenantInterceptorConfig;
    private boolean clusterLinkMetricReductionAdvancedEnabled;
    private boolean recordApiVersionsRequests;
    private int clientIdsPerTenantCap;

    public MultiTenantInterceptor() {
        this(Time.SYSTEM);
    }

    public MultiTenantInterceptor(Time time) {
        this.time = time;
        this.tenantMetrics = new TenantMetrics();
        this.hotPartitionManager = new HotPartitionManager(time);
        this.clusterLinkSourceMetrics = Optional.empty();
    }

    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics, ChannelMetadataRegistry metadataRegistry) {
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal tenantPrincipal = (MultiTenantPrincipal)principal;
            this.tenantMetrics.recordAuthenticatedConnection(metrics, tenantPrincipal, clientAddress);
            if (this.recordApiVersionsRequests) {
                boolean allInformationAvailable;
                ClientInformation clientInformation = metadataRegistry.clientInformation();
                String clientId = metadataRegistry.clientId();
                boolean bl = allInformationAvailable = !ClientInformation.isNullOrEmpty((ClientInformation)clientInformation) && clientId != null && !clientId.isEmpty();
                if (allInformationAvailable) {
                    this.tenantMetrics.recordClientInformation(metrics, tenantPrincipal, clientInformation, clientId, this.clientIdsPerTenantCap);
                }
            }
        } else {
            throw new IllegalStateException("Not a tenant connection");
        }
    }

    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
        this.tenantMetrics.recordAuthenticatedDisconnection();
    }

    public void onFailedAuthentication(String connectionId, InetAddress clientAddress, Metrics metrics) {
        this.tenantMetrics.recordFailedAuthentication(metrics, clientAddress);
    }

    public void onApiVersionsRequest(ClientInformation clientInformation, String clientId, KafkaPrincipal principal, Metrics metrics) {
        if (principal instanceof MultiTenantPrincipal) {
            if (this.recordApiVersionsRequests) {
                this.tenantMetrics.recordClientInformation(metrics, (MultiTenantPrincipal)principal, clientInformation, clientId, this.clientIdsPerTenantCap);
            }
        } else {
            throw new IllegalStateException("Not a tenant connection");
        }
    }

    public void configure(Map<String, ?> configs) {
        this.multiTenantInterceptorConfig = MultiTenantInterceptorConfig.fromConfigMap(configs);
        this.clusterLinkMetricReductionAdvancedEnabled = ConfluentConfigs.clusterLinkMetricReductionAdvancedEnabled(configs);
        this.recordApiVersionsRequests = ConfluentConfigs.multiTenantInterceptorCollectApiVersionsEnabled(configs);
        this.clientIdsPerTenantCap = ConfluentConfigs.multiTenantInterceptorCollectApiVersionsMaxPerTenant(configs);
        this.hotPartitionManager.configure(configs);
        this.tenantMetrics.configure(configs);
    }

    public RequestContext newContext(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics, PathAwareSniHostName sniHostName, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, boolean isProxyModeLocal, BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2, boolean shouldLogForConnection) {
        if (!(principal instanceof MultiTenantPrincipal)) {
            throw new IllegalArgumentException("Unexpected principal type " + String.valueOf(principal));
        }
        MultiTenantPrincipal tenantPrincipal = (MultiTenantPrincipal)principal;
        header.clusterLinkId().ifPresent(linkId -> {
            this.clusterLinkSourceMetrics.ifPresent(linkMetrics -> linkMetrics.ensureLinkId(linkId));
            if (!this.clusterLinkSourceMetrics.isPresent()) {
                HashMap<String, String> tenantTags = new HashMap<String, String>();
                tenantTags.put("tenant", tenantPrincipal.tenantMetadata().tenantName);
                String sensorSuffix = String.format(":%s-%s", "tenant", tenantPrincipal.tenantMetadata().tenantName);
                this.clusterLinkSourceMetrics = Optional.of(new ClusterLinkSourceMetrics(metrics, linkId, tenantTags, sensorSuffix, this.clusterLinkMetricReductionAdvancedEnabled));
            }
        });
        return new MultiTenantRequestContext(header, connectionId, requestId, clientAddress, clientPort, (MultiTenantPrincipal)principal, listenerName, securityProtocol, clientInformation, sniHostName, this.time, metrics, this.tenantMetrics, this.hotPartitionManager, this.multiTenantInterceptorConfig, this.clusterLinkSourceMetrics, isPrivilegedListener, principalSerde, authenticationContext, produceConsumeAuditLogTracker, isProxyModeLocal, fqdnPropertiesFromPpv2, shouldLogForConnection);
    }
}

